#include "TFmini.h"

using namespace std;

TFmini::TFmini(RawSerial& serial) : serial(serial) {
        
    serial.baud(115200);
    dist = 0;
    strength = 0;
    checksum = 0;
    cnt = 0;
    serial.attach(callback(this, &TFmini::receive), RawSerial::RxIrq);
    
}

TFmini::~TFmini() {
}

float TFmini::readDistance()  {
    return (float)dist/1000.0f;
}

float TFmini::readStrength()  {
    return strength;
}

void TFmini::receive()
{
    if(serial.readable()) {
        uartData[cnt] = serial.getc();
        checksum += uartData[cnt];
        if( uartData[0] != HEADER ) {
            cnt = 0;
            checksum = 0;
        } else if( cnt == 1 && uartData[1] != HEADER ) {
            cnt = 0;
            checksum = 0;
        } else if( cnt == 8 ) {
            checksum -= uartData[cnt];
            if( uartData[8] == (checksum & 0xff) ) {
                dist = (uartData[2] + uartData[3] * 256);
                strength = uartData[4] + uartData[5] * 256;
            }
            cnt = 0;
            checksum = 0;
        } else {
            cnt++;
        }
    }
}