/* Copyright (c) 2012 Nick Ryder, University of Oxford
 * nick.ryder@physics.ox.ac.uk
 *
 *  MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
  
#ifndef MBED_RANGEFINDER_H
#define MBED_RANGEFINDER_H

#include "Pulse.h"

/** Range Finder class
*/

class RangeFinder   {
    public:
        /** Create a RangeFinder object
        * @param pin Digital I/O pin the range finder is connected to.
        * @param pulsetime Time of pulse to send to the rangefinder to trigger a measurement, in microseconds.
        * @param scale Scaling of the range finder's output pulse from microseconds to meters.
        * @param offset Offset of the range finder's output pulse to adjust absolut reference.
        * @param timeout Time to wait for a pulse from the range finder before giving up.
        *        y = x/scale + offset
        */
        RangeFinder(PinName pin0, int pulsetime, float scale, float offset, int time);      // 1 Sensor
        RangeFinder(PinName pin0,PinName pin1, int pulsetime, float scale, float offset, int time); // 2 Sensors
        RangeFinder(PinName pin0,PinName pin1,PinName pin2, int pulsetime, float scale, float offset, int time); // 3 Sensors
        RangeFinder(PinName pin0,PinName pin1,PinName pin2,PinName pin3, int pulsetime, float scale, float offset, int time);   // 4 Sensors
        ~RangeFinder();
        /** Return the distance to the nearest object, or -1.0 if reading the pulse timed out.
        */
        float read_m(uint8_t);
        void read_and_filter(uint8_t);
        float operator()(uint8_t i) {
            return read_m(i);
        }
        float old_val[5];
        float val[5];
        uint8_t current_sensor;
        uint8_t n_sensors;
    private:
        PulseInOut pio0;
        PulseInOut pio1;
        PulseInOut pio2;
        PulseInOut pio3;
        float scale, offset;
        int pulsetime, timeout;
        
};

#endif