#ifndef DATA_LOGGER_H_
#define DATA_LOGGER_H_

#include <SDBlockDevice.h>
#include <FATFileSystem.h>
#include "data_structs.h"
#include "Signal.h"

extern DATA_Xchange data;
extern Serial pc;

// Data-logger Class
// log Data on SD-card
class Data_Logger
{
public:
    Data_Logger(uint8_t,float);           // constructor
    virtual ~Data_Logger();         // destructor
    void close_file(void);          // closes datafile
    void start_logging(void);
    void stop_logging(void);
    void pause_logging(void);
    void continue_logging(void);
    float data_vector[50];          // this is the data vector, where output is stored
    bool log_is_active;             // ...
    
private:
    SDBlockDevice sd;               // SD-card
    FILE *fp;                       // file pointer
    FATFileSystem fs;               // File system
    uint16_t log_number;            // ff-Number of logging file
    bool file_is_open;              // bool
    uint8_t nb_cols;                // number of columns
    Signal signal;
    Thread thread;
    Ticker ticker;
    Mutex mutex;
    void sendSignal();
    void write_line();              // write line to file
    Timer ti;                       // timer for timestamp
    float Ts;
  };



#endif

