#ifndef CONTROLLER_LOOPS_H_
#define CONTROLLER_LOOPS_H_

#include "mbed.h"
#include "AHRS.h"
#include "Signal.h"
#include "UAV.h"
#include "RCin.h"
#include "PID_Cntrl.h"



// need a few external stuff
extern DATA_Xchange data;
extern UAV copter;
extern PwmOut motor_pwms[4];
extern Serial pc;
extern RCin myRC;

class Controller_Loops{
public:
    Controller_Loops(float ,uint8_t ,uint8_t );
    Controller_Loops(float ,uint8_t ,uint8_t, bool );   // use this, if ahrs has no extra thread
    virtual ~Controller_Loops();
    void init_loop(void);
    void start_loop(void);
    void reset_all(void);
    void reset_des_z(void);
    void reset_des_z(float);
    void reset_des_yaw(float);
    PID_Cntrl rate_cntrl[3];
    PID_Cntrl vel_cntrl[3];
    PID_Cntrl pos_cntrl[3];
    void enable_stabilized(void);
    void enable_acro(void);
    void enable_alt_hold(void);
    void enable_vel_of_z_pos(void);
    void disable_all(void);
    void set_controller_limits(UAV);
    float des_z;
    float des_yaw;
    
private:

    float Ts;
    float Kv[3];
    
    float scale_PM1_to_vel, scale_PM1_to_rate, scale_PM1_to_angle;
    
    void loop(void);
    bool Rate_Controller_Running;
    bool Attitude_Controller_Running;
    bool Yaw_Controller_Running;
    bool Vel_Controller_Running;
    bool Pos_Controller_Running;
    bool Althold_Controller_Running;
    void parametrize_controllers(void);
    
    AHRS cntrl_ahrs;
    Signal signal;
    Thread thread;
    Ticker ticker;
    Mutex mutex;
    void sendSignal();
    uint8_t downsamp_1;
    uint8_t downsamp_2;
    uint8_t downsamp_counter_1;
    uint8_t downsamp_counter_2;
    float calc_des_pos(float);
    float calc_des_yaw(float);
    float deadzone(float,float,float);
    float PM1_2_F_Thrust(float);
    float max_delta;            // max tracking error in z
    float max_delta_yaw;            // max tracking error in yaw
    float max_climb_rate;
    float max_yaw_rate;
    bool with_ahrs;
    DigitalOut dout1;

    
};
#endif
