#ifndef UAV_H_
#define UAV_H_


#include "mbed.h"
#include "define_constants.h"
#include "Motor_Characteristics.h"

class UAV{
public:

    UAV(uint8_t type,uint8_t motor_type);
    Motor_Characteristics motor;
    virtual ~UAV();
    uint8_t nb_motors;
    float static_thrust_n;
    float static_thrust_F;
    float max_thrust;
    void calc_copter(void);
    float radius_from_center;   // assume each arm is equal long
    float inv_radius_from_center;   // assume each arm is equal long
    float JxJy;     // inertia kg m^2
    float Jz;
    float max_Mxy;
    float max_Mz;
    float weight;   //  kg
    uint8_t X_or_Plus; //
    float dndM;
    // functions
    void motor_mix(float* Mxyz, float FT, float *mspeed);
    float deadzone(float,float,float);
    float limit_minmax(float,float,float);
    

private:

};

#endif