#ifndef QK_STATEMACHINE_H_
#define QK_STATEMACHINE_H_

#include "mbed.h"
#include "UAV.h"
#include "Signal.h"
#include "Controller_Loops.h"
#include "RCin.h"
#include "Data_Logger.h"
#include "Read_Xtern_Sensors.h"
#include "define_constants.h"



extern RCin myRC;
extern PwmOut motor_pwms[4];
extern UAV copter;
extern Controller_Loops controller;
extern Data_Logger my_datalogger;
extern DATA_Xchange data;
extern Read_Xtern_Sensors xternal_sensors;
class QK_StateMachine
{
public:
    QK_StateMachine(float);
    virtual ~QK_StateMachine();
    void init_loop(void);
    void start_loop(void);
    
private:
    uint8_t CS;
    uint8_t local_FM;           // local Flight mode
    void loop(void);
    Signal signal;
    Thread thread;
    Ticker ticker;
    void sendSignal();
    bool flightmode_changed;
    bool disarm_flag;
    Timer timer;
    float Ts;
    float dt;
    uint8_t get_new_flightmode(void);
    DigitalOut dout2;

};
#endif