#include "Motor_Characteristics.h"

using namespace std;

Motor_Characteristics::Motor_Characteristics(uint8_t type){
switch(type)  {
        case AIRGEAR350:                         // 
            this->kF = 9.352e-6;                // New Characteristics based on measurements Sept 2019
            this->kM = 2.012E-7;
            this->alpha_F = 1/sqrt(this->kF);     // kF = 
            this->alpha_M = 1/sqrt(this->kM);     // kM = 2.012E-7 Nm / (rad/s)^2
            this->n_max = 870.0f;
            calc_n2pwm_9k5();
        break;
        case AIRGEAR350_8k4:                         // 
            this->kF = 4.395E-6;
            this->kM = 1.087E-7;
            this->alpha_F = 1/sqrt(this->kF);     // kF = 8.26E-6 N / (rad/s)^2
            this->alpha_M = 1/sqrt(this->kM);     // kM = 2.012E-7 Nm / (rad/s)^2
            this->n_max = 951.0f;                    // better: sqrt(Fmax/nbMot/kF);
            calc_n2pwm_8k4();
        break;

    default: break;
    }   
}


Motor_Characteristics::~Motor_Characteristics() {}

float Motor_Characteristics::F2n(float F){
    if(F<0.0f)
        F=0.0f;
    float n = this->alpha_F * sqrt(F);
    if(n< 0.0f)
        n = 0.0f;
    else if(n > this->n_max)
        n = n_max;
    return n;
    }

void Motor_Characteristics::calc_n2pwm_8k4(void){
    n2pwm.setup(263.0f,900.0f,1100.0,1650.0,1000.0,1650.0); // hier fuer 8k4 Propeller
    }
void Motor_Characteristics::calc_n2pwm_9k5(void){
    n2pwm.setup(195.0f,837.0f,1100.0,1650.0,1000.0,1650.0); // hier fuer 9k5 Propeller
    }
