#ifndef TFMINI_H
#define TFMINI_H

#include <mbed.h>

/**
 * This is a device driver class for the TFmini LiDAR.
 */
class TFmini
{
    public:

        TFmini(RawSerial& serial);

        /** Return the distance to the nearest object, or -1.0 if not valid.
        */
        float operator()() {
            return readDistance();
        }
        
        virtual     ~TFmini();
        
        float readDistance();
        float readStrength();
        
    private:
    
        RawSerial&  serial;     // reference to serial interface for communication
    
        int16_t  dist;          // actual distance measurements of LiDAR
        int16_t  strength;      // signal strength of LiDAR
        uint16_t checksum;      // save check value
        
        uint8_t  uartData[9];   // buffer for seriel uart LiDar data
        uint8_t  cnt;           // dataCounter
        
        static const uint8_t  HEADER = 0x59;     //frame header of data package
    
        void     receive();
        
};

#endif