#include "mbed.h"
#include "TFmini.h"

/*  Notes pmic 15.08.2019:
  -
*/

Serial pc(SERIAL_TX, SERIAL_RX);  // serial connection via USB - programmer
InterruptIn Button(USER_BUTTON);  // User Button
Ticker  LoopTimer;                // interrupt for control loop

RawSerial uart(PC_10, PC_11);
TFmini tfmini(uart);

float dist;              // actual distance measurements of LiDAR
float strength;

int   k;
bool  doRun;
float Ts = 0.02f;        // sample time of main loop
float dt;
Timer twhile;            // timer for time measurement (usage in while(1), without timer attached)

// user defined functions
void updateLoop(void);   // loop (via interrupt)
void pressed(void);      // user Button pressed
void released(void);     // user Button released

// main program and control loop
// -----------------------------------------------------------------------------
int main()
{
    pc.baud(2000000);                   // for serial comm.
    LoopTimer.attach(&updateLoop, Ts); // attach loop to timer interrupt
    Button.fall(&pressed);             // attach key pressed function
    Button.rise(&released);            // attach key pressed function
    k = 0;
    doRun = false;
    // pt1.reset(0.0f);
    dist = 0.0f;
    strength = 0.0f;
    dt = 0.0f;
    twhile.start();
}

// the updateLoop starts as soon as you pressed the blue botton
void updateLoop(void)
{
    float dt = twhile.read();
    twhile.reset();
    
    dist = tfmini();
    strength = tfmini.readStrength();
    if(doRun) {
        pc.printf("%i %f %f %f \r\n", k, dt, dist, strength);
    }
    k++;
}

// buttonhandling
// -----------------------------------------------------------------------------
// start timer as soon as button is pressed
void pressed() {}

// evaluating statemachine
void released()
{
    // toggle state over boolean
    doRun = !doRun;
    k = 0;
}




