#include "mbed.h"
#include "HP206C.h"
#include "IIR_filter.h"

/*  Notes pmic 25.06.2019:
  -
*/

/*
Serial pc(SERIAL_TX, SERIAL_RX);
HP206C barometer(D14, D15);
float altitude = 0.0f;


*/

HP206C barometer(D14, D15); // 20 Hz parametrization
float altitude = 0.0f;

Serial pc(SERIAL_TX, SERIAL_RX);  // serial connection via USB - programmer
InterruptIn Button(USER_BUTTON);  // User Button
Ticker  LoopTimer;                // interrupt for control loop
Timer t;                          // timer to analyse Button
Timer twhile;                     // timer for time measurement (usage in while(1), without timer attached)

int   k;
bool  doRun = false;
float Ts = 0.05f;                 // sample time of main loop, 20 Hz

IIR_filter pt1(0.2f, Ts, 1.0f);
float altitudef = 0.0f;

// user defined functions
void updateLoop(void);   // loop (via interrupt)
void pressed(void);      // user Button pressed
void released(void);     // user Button released

// main program and control loop
// -----------------------------------------------------------------------------
int main()
{
    pc.baud(2000000);                   // for serial comm.
    Button.fall(&pressed);             // attach key pressed function
    Button.rise(&released);            // attach key pressed function
    k = 0;
    pt1.reset(0.0f);
    barometer.reset();
    wait(1.0f);
    // LoopTimer.attach(&updateLoop, Ts); // attach loop to timer interrupt
    ///*
    twhile.start(); // timer for time measurement (usage in while(1), without timer attached)
    while(1) {
        altitude = barometer();
        altitudef = pt1(altitude);
        if(doRun) {
            // use this section to do dynamical measurements
            if(doRun && k++ < 2000) {
            // if(doRun) {
            //     k++;
                pc.printf("%10i %10.6e %10.6e\r\n", k, twhile.read(), altitude);
            }
        }
    }
    //*/
}

// original
/*
    pc.baud(115200);
    barometer.reset();
    while(1) {
        altitude = barometer();
        pc.printf("altitude %f\r\n", altitude);
        wait_ms(20); // don't hammer the serial console
    }
*/

// the updateLoop starts as soon as you pressed the blue botton
void updateLoop(void)
{
    altitude = barometer();
    altitudef = pt1(altitude);
    if(doRun) {
        ///*
        // use this section to do dynamical measurements
        if(doRun && k++ < 2000) {
            pc.printf("%10i %10.6e\r\n", k, altitude);
        }
        //*/
        /*
        // use this section to do static measurements
        if(doRun && k++%25 == 0) {
            pc.printf("%10i %10.6e\r\n", k, altitudef);
        }
        */
    }
}

// buttonhandling
// -----------------------------------------------------------------------------
// start timer as soon as button is pressed
void pressed()
{
    t.start();
}

// evaluating statemachine
void released()
{
    // toggle state over boolean
    if(doRun) {
        k = 0;
        pt1.reset(0.0f);
        twhile.reset(); // timer for time measurement (usage in while(1), without timer attached)
    }
    doRun = !doRun;
    t.stop();
    t.reset();
}