class GPA
{
public:
    
    GPA(float fMin, float fMax, int NfexcDes, float Aexc0, float Aexc1, float Ts);
    GPA(float fMin, float fMax, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1, int NstartMin, int NsweepMin);
    GPA(float f0, float f1, float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1, int NstartMin, int NsweepMin);
    GPA(float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1, int NstartMin, int NsweepMin);

    float operator()(float inp, float out) {
        return update((double)inp, (double)out);
    }

    virtual ~GPA();

    void     reset();
    float    update(double inp, double out);

    void     printGPAfexcDes();
    void     printGPAmeasPara();
    void     printFullGPAmeasPara();
    void     printGPAmeasTime();
    void     printNfexcDes();

private:

    int     NfexcDes;
    int     NperMin;
    int     NmeasMin;
    double  Ts;
    double *fexcDes;
    double  aAexcDes;
    double  bAexcDes;

    double  fnyq;
    double  pi2;
    double  pi2Ts;
    double  piDiv2;
    float   rad2deg;

    int     Nmeas;
    int     Nper;
    double  dfexc;
    double  fexc;
    double  fexcPast;
    int     i;
    int     j;
    double  scaleG;
    double  cr;
    double  ci;
    double *sU;
    double *sY;
    double  sinarg;
    int     NmeasTotal;
    double  Aexc;
    double  AexcPast;
    double  pi2Tsfexc;
    int     NstartMin;
    int     NsweepMin;
    int     Nsweep;
    double  bfexc;
    double  afexc;
    double  aAexc;
    double  bAexc;
    double  AexcOut;
    
    void    assignParameters(int NfexcDes, int NperMin, int NmeasMin, double Ts, int NstartMin, int NsweepMin);
    void    calculateDecreasingAmplitudeCoefficients(double Aexc0, double Aexc1);
    void    initializeConstants(double Ts);
    void    assignFilterStorage();
    void    fexcDesLogspace(double fMin, double fMax, int NfexcDes);
    void    calcGPAmeasPara(double fexcDes_i);
    void    calcGPAsweepPara();
    double  wrapAngle(double angle);
    void    printLongLine();
    void    printLine();

};
