#include "mbed.h"
#include "IIR_filter.h"

/*  Notes pmic 07.08.2019:
  - ...
*/

AnalogIn dist(PC_4);                      // analog IN (acc x) on PA_0
float d = 0.0f;

Serial pc(SERIAL_TX, SERIAL_RX);  // serial connection via USB - programmer
InterruptIn Button(USER_BUTTON);  // User Button
Ticker  LoopTimer;                // interrupt for control loop
Timer t;                          // timer to analyse Button

int   k;
bool  doRun = false;
float Ts = 0.05f;                 // sample time of main loop, 50 Hz

IIR_filter pt1(0.5f, Ts, 1.0f);
float df = 0.0f;

// user defined functions
void updateLoop(void);   // loop (via interrupt)
void pressed(void);      // user Button pressed
void released(void);     // user Button released

// main program and control loop
// -----------------------------------------------------------------------------
int main()
{
    pc.baud(2000000);                  // for serial comm.
    LoopTimer.attach(&updateLoop, Ts); // attach loop to timer interrupt
    Button.fall(&pressed);             // attach key pressed function
    Button.rise(&released);            // attach key pressed function
    k = 0;
    pt1.reset(0.0f);
}

// the updateLoop starts as soon as you pressed the blue botton
void updateLoop(void)
{
    // d = usGain*rangefinder() + usOffset;
    d = dist.read();
    df = pt1(d);
    if(doRun) {
        ///*
        // use this section to do dynamical measurements
        if(doRun && k++ < 1600) {
            pc.printf("%10i %10.9e\r\n", k, d);
        }
        //*/
        /*
        // use this section to do static measurements
        if(doRun && k++%25 == 0) {
            pc.printf("%10i %10.6e\r\n", k, df);
        }
        */
    }
}

// buttonhandling
// -----------------------------------------------------------------------------
// start timer as soon as button is pressed
void pressed()
{
    t.start();
}

// evaluating statemachine
void released()
{
    // toggle state over boolean
    if(doRun) {
        k = 0;
        pt1.reset(0.0f);
    }
    doRun = !doRun;
    t.stop();
    t.reset();
}

