#include "mbed.h"

DigitalIn pulsador1 (PTC12);
DigitalIn pulsador2 (PTC13);
DigitalIn pulsador3 (PTC16);

DigitalOut ledrojo(LED_RED);
DigitalOut ledazul(LED_BLUE);
DigitalOut ledverde(LED_GREEN);

Ticker pulso1;
Ticker pulso2;
Ticker pulso3;
Ticker aviso;
Ticker mostrar;


void detector1();
void detector2();
void detector3();
void intermitencia();

int verificacion1=0, verificacion2=0, verificacion3=0, rebote1=0, rebote2=0, rebote3=0;
char secuencia[5], turno=0;
int juego=0, obtener_num_random=0, i=0, turno_actual=0;


int main()
{
    __enable_irq();

    pulsador1.mode(PullUp);
    pulsador2.mode(PullUp);
    pulsador3.mode(PullUp);

    pulso1.attach(&detector1,0.01);
    pulso2.attach(&detector2,0.01);
    pulso3.attach(&detector3,0.01);

    ledrojo=1;
    ledverde=1;
    ledazul=1;

    srand(time(NULL));

    if (juego==0)
        aviso.attach(&intermitencia, 1);

    while (juego==0) {
        if (pulsador2==0 && juego==0) {
            juego=1;
        }
    }
    
    while (true) {
        if (juego==1 && turno<5) {
            turno_actual=rand () % 3;
            secuencia[turno]=turno_actual;
            turno++;
        }
        
        for (i=0;i<turno;i++){
            switch(turno_actual) {

                case 0:
                    ledrojo=0;
                    ledverde=1;
                    ledazul=1;
                    break;

                case 1:
                    ledrojo=1;
                    ledverde=0;
                    ledazul=1;
                    break;

                case 2:
                    ledrojo=1;
                    ledverde=1;
                    ledazul=0;
                    break;
            }
        }
    }
    
}

void detector1()
{
    if (pulsador1==0 && verificacion1==0) {
        verificacion1=1;
        rebote1=4;
    }
    if (pulsador1==0 && verificacion1==1) {
        if (rebote1>0)
            rebote1--;
    }
    if(rebote1==0 && verificacion1==1 && pulsador1==1) {
        verificacion1=0;
    }
}

void detector2()
{
    if (pulsador2==0 && verificacion2==0) {
        verificacion2=1;
        rebote2=4;
    }
    if (pulsador2==0 && verificacion2==1) {
        if (rebote2>0)
            rebote2--;
    }
    if(rebote2==0 && verificacion2==1 && pulsador2==1) {
        verificacion2=0;
    }
}

void detector3()
{
    if (pulsador3==0 && verificacion3==0) {
        verificacion3=1;
        rebote3=4;
    }
    if (pulsador3==0 && verificacion3==1) {
        if (rebote3>0)
            rebote3--;
    }
    if(rebote3==0 && verificacion3==1 && pulsador3==1) {
        verificacion3=0;
    }
}

void intermitencia()
{
    if (juego==0) {
        printf("-------------------ATENCION---------------------\n");
        printf("Presione el pulsador del medio para comenzar\n");
        ledrojo=!ledrojo;
    }
    if (juego==1) {
        printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
        printf("-----------------ATENCION---------------------\n");
        printf("QUE COMIENCE EL JUEGO\n");
        printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
        aviso.detach();
    }
}


