#include "mbed.h"
#include "MMA8451Q.h"
#include "math.h"
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
float x, y, z,horl;
Ticker timer1;
void imprimo();

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    timer1.attach(&imprimo, 1);
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        rled = 1.0f - x;
        gled = 1.0f - y;
        bled = 1.0f - z;
        wait(0.1f);
       
    }
}
void imprimo ()
{
    printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
    horl=atan(x/sqrt(pow(y,2)+pow(z,2)))*60.28;
    //horl=atan(-x/z);
    printf("%f\n",horl);
}
