#include "mbed.h"

Serial pc(USBTX,USBRX);
Timer sonerTimer;
InterruptIn sonerPin(p22);
double sonerDistTime=0;

void sonerInterruptStart(){
    sonerTimer.start();
}
void sonerInterruptStop(){
    sonerTimer.stop();
    sonerDistTime = sonerTimer.read_us();
    sonerTimer.reset();
}

int main() {
    sonerPin.rise(&sonerInterruptStart);
    sonerPin.fall(&sonerInterruptStop);
    while(1) {
        pc.printf("DistTime: %f\n\r",sonerDistTime);
        pc.printf("CalculatedDist: %f\n\r",sonerDistTime*0.017262 + 2.1727);
        wait(0.5);
    }
}
