#include "mbed.h"

Serial pc(USBTX,USBRX);
Serial twe(p13,p14);
char data[74];
int data_count;
int data_num;
int z_int;
double z_double;
int offset = (int)'0';
float cadence;
bool datas_title_flag=false;

int main() {
    twe.baud(115200);
    pc.baud(115200);
    data_num=0;
    data_count=0;
    while(1) {
        if(twe.readable()){
            data[data_count]=twe.getc();
            
            if(data[data_count]=='\r'){
                for(int i=0;i<73;i++) data[i]= NULL;
                data_num=0;
                pc.putc('!');
                data_count=0;
            }else{
                if(data[data_count]==';'){
                    data_num++;
                    datas_title_flag=true;
                }
                if(data_num==1){
                    if(datas_title_flag){
                        pc.printf("\n\r time:");
                        datas_title_flag=false;
                    }else{
                        pc.putc(data[data_count]);
                    }
                }else if(data_num==6){
                    if(datas_title_flag){
                        pc.printf("\n\r voltage:");
                        datas_title_flag=false;
                    }else{
                        pc.putc(data[data_count]);
                    }
                }else if(data_num==14){
                    if(datas_title_flag){
                        pc.printf("\n\r Z:");
                        datas_title_flag=false;                        
                    }else{
                        pc.putc(data[data_count]);
                    }
                }else if(data_num==15){
                    z_int = (int)data[data_count-1] + (int)data[data_count-2]*10 + (int)data[data_count-3]*100 - offset*111;
                    if(data[data_count-4]!='0') z_int *= -1;
                    z_double = (double)z_int/6; //角度補正前ふつうに
                    pc.printf("\n%f",z_double);
                    //pc.putc('\n');
//                    pc.putc(data[data_count]);
                }
                data_count++; 
            }//else
            
        } //readable
    }//while
} //main
//一行72文字
