#include "mbed.h"

#define SERIAL_TX PA_2
#define SERIAL_RX PA_3

Serial pc(USBTX,USBRX);

InterruptIn rotEnc(p5);
PwmOut airSpeedServo(p21);
Timer timer;

#define air_a 0.05945
#define air_b 1.12
#define air_k 0.14737
#define air_n 1.19
#define SUM_NUM 10
#define airMaxPin 4
#define BUFFER 30
#define EN_A 3

float airSpeed=0.0;
float airSpeed_ave = 0.0;
float airSpeed_max = 0.0;
volatile int kaitensu= 0;
int beforetime=0;
int counter = 0;
float sum[SUM_NUM] = {0.0};


void count_up(){
    kaitensu = kaitensu + 1;
}
  
float make_ave(float s[], int n){
    float p = 0;
    int i;
    for(i = 0; i < n; i++){
       p += s[i];    
    }
    if(n != 0)
    return p / n;    
    else
    return 0;
}

void AirSpeed(){
  timer.start();
  int interval = (int)timer.read_ms() - beforetime;
  if(interval >= 100)    
  {
      beforetime = (int)timer.read_ms();
      
      float x = 0.000335 * kaitensu * kaitensu + 0.0726 * kaitensu;
      
      airSpeed = (float)air_k * (float)pow((double)x, 1 / air_n);
      
      sum[counter % SUM_NUM] =  (float)airSpeed;
      if(counter % SUM_NUM == 0)
        counter = 0;
      airSpeed_ave = make_ave(sum, SUM_NUM);
      if(airSpeed_ave > airSpeed_max)
        airSpeed_max = airSpeed_ave;  
      counter++;
      kaitensu = 0;
    }    
  }

void count(){
    airSpeed_ave++;
    }

int main(){
    pc.baud(9600);
    rotEnc.rise(count_up);
    airSpeedServo.period(0.020);
  pc.putc(10);
    while(1){
      AirSpeed();
     // count();
     pc.printf("%f\n\r",airSpeed_ave);
        //airSpeedServo.pulsewidth(0.001 + airSpeed_ave / 1000);
 
   }
   return 0;
}