//;2648 ;00 00000 0;168 ;001; 10043 c1;31 10;00 00;00 00;10 63;08 39;I; -012; 0002; 0104;\r\n
//;109  ;00 00000 0;123 ;011; 10008 e4;27 95;00 00;00 00;13 99;08 51;G; -068; -096; -192;
#ifndef CADENCE_H
#define CADENCE_H

#include "mbed.h"
#include <string>
DigitalOut led3(LED3);
Timer cadenceT;
RawSerial pc(USBTX,USBRX);
class Cadence : public RawSerial
{
private:
    static const int DATAS_NUM = 75,BuffNum = 500;

protected:

public:
    char strV[5];
    char strC[5];
    char data[DATAS_NUM],myBuff[BuffNum],c;
    string strData;
    int dataCount, data_num, strlength;
    double cadence, voltage;
    Cadence(PinName tx, PinName rx, const char* name = NULL) : RawSerial(tx, rx) {
        for(int i=0; i<DATAS_NUM; i++) data[i]= '\0';
        for(int i = 0; i<BuffNum; i++) myBuff[i] = '\0';
        data_num=0;
        dataCount=0;
        baud(115200);
        cadence=0;
        voltage=0;
        strcpy(strC,"0000");
        strcpy(strV,"0000");
        cadenceT.start();
        attach(this, &Cadence::readData, RawSerial::RxIrq);
    }
    int checkInt(const char c[]) {
        for(int i = 0; i<strlen(c); i++) {
            if( c[0] == '-' ) continue;
            if( c[i] - '0' > 9 || c[i] - '0' <0 ) return -1;
        }
        return 1;
    }
    void readData() {
        if(readable()) {
            led3 = 1;
            cadenceT.reset();
            cadenceT.start();
            dataCount = 0;
            do {
                myBuff[dataCount] = getc();
                dataCount++;
            } while(cadenceT.read_ms()<10 && myBuff[dataCount-1] != '\n');
            if(dataCount < DATAS_NUM-4) return;
        }
        if(dataCount != 0) {
//        led3 = 1;//Ticker内でTimer&stringを使うとフリーズ
//            strData = "hello";
//            pc.printf("%s\n\r",strData.c_str());
//            for(int i = 0; i<strlen(myBuff); i++) {
//                pc.printf("mybuff[%d]:%c\n\r",i,myBuff[i]);
//                strData += myBuff[i];
//        led3 = 0;
//            }
//            strData = string(myBuff,DATAS_NUM);
            strlength = strlen(myBuff)/*strData.length()*/;
            if( strlength > DATAS_NUM-4 && strlength <= DATAS_NUM ) {
            for(int i = 0; i<4; i++){
                strC[i] = myBuff[strlength-7+i];
                strV[i] = myBuff[strlength-44+i];
            }
            if( checkInt(strC) ) {
                sscanf(strC,"%lf",&cadence);
                cadence /= 6.0;
            }
            if( checkInt(strV) ) {
                sscanf(strV,"%lf",&voltage);
                voltage *= 0.001;
            }
//                switch (strlength) {
//                    case DATAS_NUM-3 :
//                        strData.erase(0,2);
//                        break;
//                    case DATAS_NUM-2 :
//                        strData.erase(0,3);
//                        break;
//                    case DATAS_NUM-1 :
//                        strData.erase(0,4);
//                        break;
//                    case DATAS_NUM :
//                        strData.erase(0,5);
//                }
//                strV = strData.substr(27,4);
//                strC = strData.substr(64,4);
//                if( checkInt( strV.c_str() ) ) sscanf(strV.c_str(),"%lf",&voltage);
//                if( checkInt( strC.c_str() ) ) sscanf(strC.c_str(),"%lf",&cadence);

//            pc.printf("%d\n\r",strlen(strV));
            }//strlength
            pc.printf("\n\rmyBuff:%s(%d)\n\r",myBuff,strlength);
            pc.printf("strC:%s\n\r",strC);
            for (int i = 0; i < strlength; i++) myBuff[i] = '\0';
            dataCount = 0;
        }//if(dataCount != 0)
        led3 = 0;
    }//readData
};
#endif