#ifndef FUSOKUKEI_H
#define FUSOKUKEI_H

#include "mbed.h"


#define AIR_K 0.14737
#define AIR_N 1.12
#define AIR_A 1.4314
#define AIR_B 0.209
#define AIR_SUM_NUM 20
#define AIR_BUFFER 30

float airSpeed = 0.0;
float airSpeed_ave = 0.0;
float airSpeed_max = 0.0;
int air_counter = 0;
float air_sum[AIR_SUM_NUM] = {0.0};

class Fusokukei{
    protected:
    
    public:      
    float make_ave(float s[], int n){
        float p = 0;
        int i;
        for(i = 0; i < n; i++){
           p += s[i];    
        }
        if(n != 0)
        return p / n;    
        else
        return 0;
    }
    
    void calcAirSpeed(float x){
          air_sum[air_counter % AIR_SUM_NUM] = (float)AIR_K * (float)pow((double)x, 1 / AIR_N);
          if(air_counter % AIR_SUM_NUM == 0)
            air_counter = 0;
          airSpeed_ave = make_ave(air_sum, AIR_SUM_NUM);
          //airSpeed = airSpeed_ave*AIR_A+AIR_B;
          airSpeed=airSpeed_ave;
          if(airSpeed > airSpeed_max)
            airSpeed_max = airSpeed;  
          air_counter++;
      }
};
#endif