//計器プログラム
#include "mbed.h"
#include "Fusokukei.h"
#include "MPU6050.h"
#include "SDFileSystem.h"

#define KX_VALUE_MIN 0.4
#define KX_VALUE_MAX 0.8
#define SOUDA_DATAS_NUM 13
#define WRITE_DATAS_NUM 20
#define MPU_LOOP_TIME 0.01
#define AIR_LOOP_TIME 0.01
#define WRITE_DATAS_LOOP_TIME 1
#define ROLL_R_MAX_DEG 2
#define ROLL_L_MAX_DEG 2
#define MPU_DELT_MIN 500
#define SD_WRITE_NUM 10
#define INIT_SERVO_PERIOD_MS 20

Serial pc(USBTX,USBRX);
Serial soudaSerial(p13,p14);
Serial twe(p9,p10);
Ticker writeDatasTicker;
Timer writeTimer;

InterruptIn FusokukeiPin(p30);
Ticker FusokukeiTicker;
Fusokukei air;
volatile int air_kaitensu= 0;

float sum = 0;
uint32_t sumCount = 0;
MPU6050 mpu6050;
Timer t;
Ticker mpu6050Ticker;

AnalogIn kx_X(p17);
AnalogIn kx_Y(p16);
AnalogIn kx_Z(p15);
float KX_X,KX_Y,KX_Z;

DigitalOut RollAlarmR(p20);
DigitalOut RollAlarmL(p19);
DigitalOut led(LED1);
DigitalOut led2(LED2);

SDFileSystem sd(p5, p6, p7, p8, "sd");
FILE* fp;

PwmOut kisokuServo(p22);
PwmOut geikakuServo(p25);

char soudaDatas[SOUDA_DATAS_NUM];
float writeDatas[SD_WRITE_NUM][WRITE_DATAS_NUM];
volatile int write_datas_index = 0;

void air_countUp();
void call_calcAirSpeed();
void init();
void FusokukeiInit();
void MpuInit();
void mpuProcessing();
void SdInit();
void DataReceiveFromSouda();
void WriteDatas();
float calcAttackAngle();
float calcKXdeg(float x);

void air_countUp(){
    air_kaitensu++;
}

void call_calcAirSpeed(){
    air.calcAirSpeed(air_kaitensu);
    air_kaitensu = 0;
}

void init(){
    twe.baud(115200);
    writeTimer.start();
    kisokuServo.period_ms(INIT_SERVO_PERIOD_MS);
    geikakuServo.period_ms(INIT_SERVO_PERIOD_MS);
    FusokukeiInit();
    MpuInit(); 
    SdInit();
    //writeDatasTicker.attach(&WriteDatas,1);
    //soudaSerial.attach(&DataReceiveFromSouda, Serial::RxIrq);
}

void FusokukeiInit(){
    FusokukeiPin.rise(air_countUp);
    FusokukeiTicker.attach(&call_calcAirSpeed, AIR_LOOP_TIME);
}

void MpuInit(){
    i2c.frequency(400000);  // use fast (400 kHz) I2C
    t.start();
    uint8_t whoami = mpu6050.readByte(MPU6050_ADDRESS, WHO_AM_I_MPU6050);  // Read WHO_AM_I register for MPU-6050
    if (whoami == 0x68) { // WHO_AM_I should always be 0x68
        wait(1);
        mpu6050.MPU6050SelfTest(SelfTest); // Start by performing self test and reporting values
        wait(1);
        if(SelfTest[0] < 1.0f && SelfTest[1] < 1.0f && SelfTest[2] < 1.0f && SelfTest[3] < 1.0f && SelfTest[4] < 1.0f && SelfTest[5] < 1.0f) {
            mpu6050.resetMPU6050(); // Reset registers to default in preparation for device calibration
            mpu6050.calibrateMPU6050(gyroBias, accelBias); // Calibrate gyro and accelerometers, load biases in bias registers
            mpu6050.initMPU6050(); //pc.printf("MPU6050 initialized for active data mode....\n\r"); // Initialize device for active mode read of acclerometer, gyroscope, and temperature
            wait(2);
        } else {
        }
    } else {
        //pc.printf("out\n\r"); // Loop forever if communication doesn't happen
    }   
}

double calcPulse(int deg){
    return (0.0006+(deg/180.0)*(0.00235-0.00045));

}

void mpuProcessing(){
    if(mpu6050.readByte(MPU6050_ADDRESS, INT_STATUS) & 0x01) {  // check if data ready interrupt
        mpu6050.readAccelData(accelCount);  // Read the x/y/z adc values
        mpu6050.getAres();
        ax = (float)accelCount[0]*aRes - accelBias[0];  // get actual g value, this depends on scale being set
        ay = (float)accelCount[1]*aRes - accelBias[1];
        az = (float)accelCount[2]*aRes - accelBias[2];
        mpu6050.readGyroData(gyroCount);  // Read the x/y/z adc values
        mpu6050.getGres();
        gx = (float)gyroCount[0]*gRes; // - gyroBias[0];  // get actual gyro value, this depends on scale being set
        gy = (float)gyroCount[1]*gRes; // - gyroBias[1];
        gz = (float)gyroCount[2]*gRes; // - gyroBias[2];
        tempCount = mpu6050.readTempData();  // Read the x/y/z adc values
        temperature = (tempCount) / 340. + 36.53; // Temperature in degrees Centigrade
    }
    Now = t.read_us();
    deltat = (float)((Now - lastUpdate)/1000000.0f) ; // set integration time by time elapsed since last filter update
    lastUpdate = Now;
    sum += deltat;
    sumCount++;
    if(lastUpdate - firstUpdate > 10000000.0f) {
        beta = 0.04;  // decrease filter gain after stabilized
        zeta = 0.015; // increasey bias drift gain after stabilized
    }
    mpu6050.MadgwickQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f);
    delt_t = t.read_ms() - count;
    if (delt_t > MPU_DELT_MIN) {
        yaw   = atan2(2.0f * (q[1] * q[2] + q[0] * q[3]), q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3]);
        pitch = -asin(2.0f * (q[1] * q[3] - q[0] * q[2]));
        roll  = atan2(2.0f * (q[0] * q[1] + q[2] * q[3]), q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3]);
        pitch *= 180.0f / PI;
        yaw   *= 180.0f / PI;
        roll  *= 180.0f / PI;
        myled= !myled;
        count = t.read_ms();
        sum = 0;
        sumCount = 0;
    }
}

void SdInit(){
    mkdir("/sd/mydir", 0777);
    fp = fopen("/sd/mydir/sdtest2.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!\n\r");
    fclose(fp);
}

void DataReceiveFromSouda(){
    led2 = !led2;
    //pc.printf("received\n\r");
    for(int i = 0; i < SOUDA_DATAS_NUM; i++){
        soudaDatas[i] = soudaSerial.getc();
    }
}

void SDprintf(){
    fp = fopen("/sd/mydir/sdtest.csv", "a");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    for(int i = 0; i < SD_WRITE_NUM; i++){
        for(int j = 0; j < WRITE_DATAS_NUM; j++){
            fprintf(fp,"%f,", writeDatas[i][j]);
            //if(i%7==0){
//                fprintf(fp,"\n\r");
//            }
        }
    }
    //for(int i = 0; i < SOUDA_DATAS_NUM; i++){
//        fprintf(fp,"%i   ",soudaDatas[i]);
//    }
//    fprintf(fp, "p:%f,r:%f,y:%f\n",pitch,roll,yaw);
//    fprintf(fp, "gx:%f,gy:%f,gz:%f\n",calcKXdeg(kx_X.read()),calcKXdeg(KX_Y),calcKXdeg(KX_Z));
//    fprintf(fp, "as:%f\n",airSpeed);
    fprintf(fp,"\n\r");
    fclose(fp);
}

void WriteDatas(){
    int i;
    for(i = 0; i < SOUDA_DATAS_NUM; i++){
        writeDatas[write_datas_index][i] = (float)soudaDatas[i];
    }
    writeDatas[write_datas_index][i++] = calcKXdeg(kx_X.read());
    writeDatas[write_datas_index][i++] = calcKXdeg(kx_Y.read());
    writeDatas[write_datas_index][i++] = calcKXdeg(kx_Z.read());
    writeDatas[write_datas_index][i++] = pitch;
    writeDatas[write_datas_index][i++] = roll;
    writeDatas[write_datas_index][i++] = yaw;
    writeDatas[write_datas_index][i++] = airSpeed;
    //writeDatas[write_datas_index][i++] = writeTimer.read();
    for(i = 0; i < WRITE_DATAS_NUM; i++){
        pc.printf("%f   ", writeDatas[write_datas_index][i]);
        twe.printf("%f,", writeDatas[write_datas_index][i]);
    }
    pc.printf("\n\r");
    twe.printf("\n\r");
    if(write_datas_index == SD_WRITE_NUM-1){
        SDprintf();
        write_datas_index=0;
    }
    else{
        write_datas_index++;
    } 
        //for(int i = 0; i < SOUDA_DATAS_NUM; i++){
//            pc.printf("%i   ",soudaDatas[i]);
//            twe.printf("%i  ",soudaDatas[i]);
//        }
//        pc.printf("\n\r");
//        twe.printf("\n\r");
//        twe.printf("%f,%f,%f\n\r",pitch,roll,yaw);
//        twe.printf("%f,%f,%f\n\r",calcKXdeg(kx_X.read()),calcKXdeg(KX_Y),calcKXdeg(KX_Z));   
//        twe.printf("%f\n\r",airSpeed); 
//        pc.printf("%f,%f,%f\n\r",pitch,roll,yaw);
//        pc.printf("%f,%f,%f\n\r",calcKXdeg(kx_X.read()),calcKXdeg(KX_Y),calcKXdeg(KX_Z));   
//        pc.printf("%f\n\r",airSpeed);
//        SDprintf();
}

float calcKXdeg(float x){
    return -310.54*x+156.65;
}

float calcAttackAngle(){
    return pitch-calcKXdeg(kx_Z.read());
}

void RollAlarm(){ 
    if((roll < 0) && (roll > ROLL_L_MAX_DEG-180)){
        RollAlarmL = 1;
    }
    else{
        RollAlarmL = 0;
    }
    
    if((roll > 0) && (roll < 180-ROLL_R_MAX_DEG)){
        RollAlarmR = 1;
    }
    else{
        RollAlarmR = 0;
    }
}

void WriteServo(){
    kisokuServo.pulsewidth(calcPulse(airSpeed*10));
    //geikakuServo.pulsewidth(calcPulse(pitch*0.13));
    
    //kisokuServo.pulsewidth(calcPulse(0));
    //geikakuServo.pulsewidth(calcPulse(0));
}

int main(){
    init();
    while(1){
        mpuProcessing();
        RollAlarm();
        DataReceiveFromSouda();
        WriteDatas();
        WriteServo();
    }
}