//中央can program

#include "mbed.h"
#define WAIT_LOOP_TIME 0.1
#define YOKUTAN_DATAS_NUM 4
#define IMPUT_DATAS_NUM 2
#define SEND_DATAS_CAN_ID 100
#define SEND_DATAS_TIME 0.1
#define THRESHOLD_OH_VALUE 0.14
#define CALC_CADENCE_TIME 0.05

CAN can_R(p30,p29);
CAN can_L(p9,p10);
Serial toKeikiSerial(p13,p14);
Serial pc(USBTX,USBRX);
DigitalIn eruron_R(p22);
DigitalIn eruron_L(p20);
DigitalIn drug_R(p23);
DigitalIn drug_L(p19);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
Ticker sendDatasTicker;
Ticker cadenceTicker;
Timer cadenceTimer;
AnalogIn p(p15);
AnalogIn q(p16);

char yokutanDatas_R[YOKUTAN_DATAS_NUM];
char yokutanDatas_L[YOKUTAN_DATAS_NUM];
char inputDatas_R[IMPUT_DATAS_NUM];
char inputDatas_L[IMPUT_DATAS_NUM];
char cadence = 0;
bool stateP = true;
bool stateQ = true;
bool stateP_old = true;
bool stateQ_old = true;

CANMessage recmsg_R;
CANMessage recmsg_L;

void InputControlValues(){
    inputDatas_R[1] = (char)drug_R;
    inputDatas_L[1] = (char)drug_L;
    if(eruron_R){
        inputDatas_R[0] = 0;
        inputDatas_L[0] = 2;
    }
    else if(eruron_L){
        inputDatas_R[0] = 2;
        inputDatas_L[0] = 0;
    }
    else{
        inputDatas_R[0] = 1;
        inputDatas_L[0] = 1;
    }
}

void toString_R(){
    pc.printf("R:");
    for(int i = 0; i < IMPUT_DATAS_NUM; i++){
        pc.printf("%d:%i    ",i,inputDatas_R[i]);
    }
}

void toString_L(){
    pc.printf("L:");
    for(int i = 0; i < IMPUT_DATAS_NUM; i++){
        pc.printf("%d:%i    ",i,inputDatas_L[i]);
    }
    pc.printf("\n\r");
}

void SendDatas(){
    can_R.write(CANMessage(SEND_DATAS_CAN_ID, inputDatas_R, IMPUT_DATAS_NUM));
    can_L.write(CANMessage(SEND_DATAS_CAN_ID, inputDatas_L, IMPUT_DATAS_NUM));
    for(int i = 0; i < YOKUTAN_DATAS_NUM; i++){
        toKeikiSerial.putc(yokutanDatas_R[i]);
        toKeikiSerial.putc(yokutanDatas_L[i]);
    }
    for(int i = 0; i < IMPUT_DATAS_NUM; i++){
        toKeikiSerial.putc(inputDatas_R[i]);
        toKeikiSerial.putc(inputDatas_L[i]);
    }
    toKeikiSerial.putc(cadence);
    pc.printf("test\n\r");
}

void calcCadence(){
    //pc.printf("%f,%f\n\r",p.read(),q.read());
    if(p.read() > THRESHOLD_OH_VALUE) stateP = true;
    else stateP = false;
    if(q.read() > THRESHOLD_OH_VALUE) stateQ = true;
    else stateQ = false;
    if((stateP == true && stateP_old == false) || 
        stateQ == true && stateQ_old == false){
        cadenceTimer.stop();
        cadence = (char)30.0/cadenceTimer.read();
        pc.printf("Cadence:%i\n\r",cadence);
        cadenceTimer.reset();
        cadenceTimer.start();
    }
    stateP_old = stateP;
    stateQ_old = stateQ;
}        

void init(){
    cadenceTimer.start();
    cadenceTicker.attach(calcCadence, CALC_CADENCE_TIME);
    sendDatasTicker.attach(SendDatas,SEND_DATAS_TIME);
    for(int i = 0; i < IMPUT_DATAS_NUM; i++){
        inputDatas_R[i] = 0;
        inputDatas_L[i] = 0;
    }
}


void receiveDatas(){
    if(can_R.read(recmsg_R)){
        for(int i = 0; i < recmsg_R.len; i++){
            yokutanDatas_R[i] = recmsg_R.data[i];
        }
        myled1 = !myled1;
    }
     if(can_L.read(recmsg_L)){
        for(int i = 0; i < recmsg_L.len; i++){
            yokutanDatas_L[i] = recmsg_L.data[i];
        }
        myled2 = !myled2;
    }
}

int main(){
    init();
    while(1){
        InputControlValues();
        wait_us(10);
        receiveDatas();
        //toString_R();
//        toString_L();
        wait(WAIT_LOOP_TIME);
    }
}