#include "mbed.h"

#define BUFFER 10

Serial rs485R(p13,p14);
Serial rs485L(p28,p27);
Serial pc(USBTX,USBRX);
DigitalOut Driver_R(p5);
DigitalOut Driver_L(p6);
DigitalIn Switch(p20);
Ticker CheckData;
AnalogIn val1(p16);
AnalogIn val2(p17);

void ch_data()
{
    signed char rec_data_R[BUFFER];
    signed char rec_data_L[BUFFER];
    //signed char rec_data_R;
    rs485R.putc('P');
    wait_ms(1);
    Driver_R = 0;
    wait_ms(120);
    if(rs485R.readable()) {
        for(int i = 0; i < BUFFER; i++) {
            rec_data_R[i] = rs485R.getc();
        }
        for(int i = 0; i < BUFFER; i++) {
            if(rec_data_R[i + 1] != -1) {
                pc.printf("RIGHT : ");
                switch(rec_data_R[i]) {
                    case 'X':
                        pc.printf("  X : %5i",rec_data_R[i + 1]);
                        break;
                    case 'Y':
                        pc.printf("  Y : %5i",rec_data_R[i + 1]);
                        break;
                    case 'Z':
                        pc.printf("  Z : %5i",rec_data_R[i + 1]);
                        break;
                    case 'V':
                        pc.printf("  V : %5i",rec_data_R[i + 1]);
                        break;
                    case 'C':
                        pc.printf("  C : %5i",rec_data_R[i + 1]);
                        break;
                }
            }
        }
    }
    pc.printf("\t");

    rs485L.putc('P');
    Driver_L = 0;
    wait_ms(120);
    if(rs485L.readable()) {
        for(int i = 0; i < BUFFER; i++) {
            rec_data_L[i] = rs485L.getc();
        }
        for(int i = 0; i < BUFFER; i++) {
            if(rec_data_L[i + 1] != -1) {
                pc.printf("LEFT : ");
                switch(rec_data_L[i]) {
                    case 'X':
                        pc.printf("  X : %5i",rec_data_L[i + 1]);
                        break;
                    case 'Y':
                        pc.printf("  Y : %5i",rec_data_L[i + 1]);
                        break;
                    case 'Z':
                        pc.printf("  Z : %5i",rec_data_L[i + 1]);
                        break; 
                    case 'V':
                        pc.printf("  V : %5i",rec_data_L[i + 1]);
                        break;
                    case 'C':
                        pc.printf("  C : %5i",rec_data_L[i + 1]);
                        break;
                }
            }
        }
        pc.printf("\n\r");
        Driver_R = 1;
        Driver_L = 1;
        wait_ms(1);
    }
}

void counter_checker(int *counter_A,int *counter_B,int *counter_C,int *counter_D)
{

    (*counter_A)++;
    if(*counter_A > 180)
        *counter_A = 0;

    *counter_B = *counter_B + 2;
    if(*counter_B > 180)
        *counter_B = 0;

    *counter_C = *counter_C + 3;
    if(*counter_C > 180)
        *counter_C = 0;

    *counter_D = *counter_D + 4;
    if(*counter_D > 180)
        *counter_D = 0;
}

int main()
{
    /*右エルロン：A
     右翼端板　：B
     左エルロン：C
     左翼端板　：D
    */
    rs485R.baud(38400);
    rs485L.baud(38400);
    Driver_R = 1;
    Driver_L = 1;
    int counter_A = 0;
    int counter_B = 0;
    int counter_C = 0;
    int counter_D = 0;
    pc.printf("Driver\n\r");
    CheckData.attach(&ch_data,0.40);
    while(1) { 
        rs485R.putc(counter_A);
        rs485R.putc('B');
        rs485R.putc(counter_B);
        rs485L.putc('C');
        rs485L.putc(counter_C);
        rs485L.putc('D');
        rs485L.putc(counter_D);
        counter_checker(&counter_A,&counter_B,&counter_C,&counter_D);
        wait(0.25);
    }
}


