//中央操舵プログラム
#include "mbed.h"

#define WAIT_LOOP_TIME 0.15

Serial rs485R(p9,p10);
Serial rs485L(p13,p14);
Serial toKeikiSerial(p28,p27);
Serial pc(USBTX,USBRX);
DigitalOut DriverR(p5);
DigitalOut DriverL(p6);
Ticker CheckDataR;
Ticker CheckDataL;
DigitalIn eruronR(p7);
DigitalIn drugR(p8);
DigitalIn eruronL(p30);
DigitalIn drugL(p29);

signed char accR[3] = {0,0,0};
signed char accL[3] = {0,0,0};

signed char VR = 0;
signed char CR = 0;
signed char VL = 0;
signed char CL = 0;

void ch_dataR(){
    rs485R.putc('C');
    wait_ms(1);
    DriverR = 0;
    wait_ms(3);
    while(rs485R.readable()) {
    short ch = rs485R.getc();
        switch(ch) {
            case 'X':
                accR[0] = rs485R.getc();
                break;
            case 'Y':
                accR[1] = rs485R.getc();
                break;
            case 'Z':
                accR[2] = rs485R.getc();
                break;
            case 'V':
                VR = rs485R.getc();
                break;
            case 'I':
                CR = rs485R.getc();
                break;
            default:
                break;
        }
    }
    DriverR = 1;
    wait_ms(1);
}

void ch_dataL(){
    rs485L.putc('C');
    wait_ms(1);
    DriverL = 0;
    wait_ms(3);
    while(rs485L.readable()) {
    short ch = rs485L.getc();
        switch(ch) {
            case 'X':
                accL[0] = rs485L.getc();
                break;
            case 'Y':
                accL[1] = rs485L.getc();
                break;
            case 'Z':
                accL[2] = rs485L.getc();
                break;
            case 'V':
                VL = rs485L.getc();
                break;
            case 'I':
                CL = rs485L.getc();
                break;
            default:
                break;
        }
    }
    DriverL = 1;
    wait_ms(1);
}

void CALL_chDataR(){
    ch_dataR();
}

void CALL_chDataL(){
    ch_dataL();
}

void init(){
    DriverR = 1;
    DriverL = 1;
    rs485R.baud(38400);
    rs485L.baud(38400);
    toKeikiSerial.baud(38400);
    CheckDataR.attach(&CALL_chDataR,0.25);
    wait(0.1);
    CheckDataL.attach(&CALL_chDataL,0.25);
}

void InputAndSentControlValuesR(){
    DriverR = 1;
    rs485R.putc('A');
    rs485R.putc(eruronR);
    rs485R.putc('B');
    rs485R.putc(drugR);    
}

void InputAndSentControlValuesL(){
    DriverL = 1;
    rs485L.putc('A');
    rs485L.putc(eruronL);
    rs485L.putc('B');
    rs485L.putc(drugL);    
}

void SendDarasToKeiki(){
    for(int i = 0; i < 3; i++){
        toKeikiSerial.putc(accR[i]);
        toKeikiSerial.putc(accL[i]);
    }
    toKeikiSerial.putc(VR);
    toKeikiSerial.putc(VL);
    toKeikiSerial.putc(CR);
    toKeikiSerial.putc(CL);
    toKeikiSerial.putc(eruronR);
    toKeikiSerial.putc(eruronL);
    toKeikiSerial.putc(drugR);
    toKeikiSerial.putc(drugL);
}

int main()
{
    init();
    while(1) {
        InputAndSentControlValuesR();
        InputAndSentControlValuesL();
        SendDarasToKeiki();
        wait(WAIT_LOOP_TIME);
    }
}
