#pragma once

const static int mpu_addr = 0xd0;
typedef union {
    uint8_t reg[14]; 
    struct {
        uint8_t acc_x_L;
        uint8_t acc_x_H;
        uint8_t acc_y_L;
        uint8_t acc_y_H;
        uint8_t acc_z_L;
        uint8_t acc_z_H;
        
        uint8_t T_L;
        uint8_t T_H;
        
        uint8_t gyro_x_L;
        uint8_t gyro_x_H;
        uint8_t gyro_y_L;
        uint8_t gyro_y_H;
        uint8_t gyro_z_L;
        uint8_t gyro_z_H;
    } byte;
    
    struct {
        int16_t acc[3];
        
        int16_t T;
        
        int16_t gyro[3];
    } value;
} MPU_DATA;

class MPU6050 {
public:
    MPU6050(I2C* p_i2c);
    ~MPU6050();
    
    int init();
    int read();
    MPU_DATA data;
   void checker_set(int x){check = x;}
   int checker_get(){return check;}
private:
    I2C* i2c;
      int check;
};