#ifndef VALUE_HANDLER
#define VALUE_HANDLER

#include "mbed.h"

#define PHASE_NUM 7 //奇数にしてください。翼端コードと合わせないといけないのは、この値です
#define ADDITIONALPHASE 2
#define SUM_UP_NUM 10.0
class ValueProcess
{
private:
    float rollNeutral;
    float rollUpperDiff;
    float rollLowerDiff;

    float pitchNeutral;//1って書いた方
    float pitchUpperDiff;
    float pitchLowerDiff;
    float neutralDiff;

    enum InputType {
        enumRoll,
        enumPitch
    };
public:
    ValueProcess();
    void setNeutral(float rollRead,float pitchRead);
    void setMaxAndMin(InputType it,float value);
    float MatchUpperAndLower(InputType it, float max,float min,float neutral,float value);
    float Format2Range(float value,float max,float min);
    int PhaseFloat(float value,float max,float min);
    int WidenNeutral(int phased);
    float SetRollPitchRacio(float pitch,float roll);
    float MatchRange(float value);
    void Processing(float rollRead,float pitchRead,int* input_R,int* input_L);
};

#endif