#ifndef InputHandler
#define InputHandler

#include "mbed.h"

#define NEUWIDTH 0.05
#define NORMMAX 1.0
#define NORMMIN -1.0
#define WIDENRATE (NORMMAX/(NORMMAX - NEUWIDTH))
#define NEUTRAL_SUM_NUM 10

class InputCalc
{
private:


public:
    double rawNeu;
    double rawMax;
    double rawMin;
    double shiftedMax;
    double shiftedMin;
    double NeushiftWidth;
    double upperShiftRate;
    double lowerShiftRate;
     InputCalc();
    void setNeutral(float input);
    void setMaxAndMin(double input);

    //入力値の中央値を0とし、その分最大値と最小値をシフトします
    void shift2ZeroNeu();

    //シフトした後の値を-1.0～1.0へと正規化するための比率を取得します
    void GetNormRate();
    
    //値を-1.0～1.0へと正規化します
    void NormValue(float *input);

    //初期値の分、入力値を0に寄せて、拡大します。
    void WidenNeutral(float* input) ;
    
    void CutInvalidInput(float* input);
    
    //上記のメソッドを使用したループ内処理
    float Processing(float input);
};
#endif