#include "InputHandler.h"
#include "mbed.h"

InputCalc::InputCalc()
{
    rawNeu = 0.0;
    rawMax = NORMMIN;
    rawMin = NORMMAX;

    shiftedMax = 0.0;
    shiftedMin = 0.0;

    NeushiftWidth = 0.0;
    upperShiftRate = 0.0;
    lowerShiftRate = 0.0;
}

void InputCalc::setNeutral(float input)
{
//    float sum = 0.0;
//    for (int i = 0; i < NEUTRAL_SUM_NUM ; i++) {
//        sum += input;
//    }
//    rawNeu = sum / NEUTRAL_SUM_NUM;
    rawNeu = input;
}

void InputCalc::setMaxAndMin(double input)
{
    if (input > rawMax)
        rawMax = input;
    else if (input < rawMin)
        rawMin = input;
}

//入力値の中央値を0とし、その分最大値と最小値をシフトします
void InputCalc::shift2ZeroNeu()
{
    shiftedMax = rawMax - rawNeu;       //初期値を0へとシフトするので、最大値と最小値から中央値を引けばシフト各値もシフトできる
    shiftedMin = rawMin - rawNeu;
}

//シフトした後の値を-1.0～1.0へと正規化するための比率を取得します
void InputCalc::GetNormRate()
{
    upperShiftRate = 1.0 / shiftedMax;
    lowerShiftRate = -1.0 / shiftedMin;
}

//値を-1.0～1.0へと正規化します
void InputCalc::NormValue(float *input)
{
    *input -= rawNeu;
    if (*input > 0.0)
        *input *= upperShiftRate;
    else if (*input < 0.0)
        *input *= lowerShiftRate;
}

//初期値の分、入力値を0に寄せて、拡大します。
void InputCalc::WidenNeutral(float *input)
{
    if (-NEUWIDTH < *input&& *input < NEUWIDTH)
        *input = 0;
    else if (*input < -NEUWIDTH) {
        *input += NEUWIDTH;
        *input *= WIDENRATE;
    } else if (NEUWIDTH < *input) {
        *input -= NEUWIDTH;
        *input *= WIDENRATE;
    }
}

//範囲外の値を下限値と上限値に置き換える
void InputCalc::CutInvalidInput(float* input)
{
    if(*input > NORMMAX)
        *input = NORMMAX;
    else if(*input < NORMMIN)
        *input = NORMMIN;
}

float InputCalc::Processing(float input)
{
    setMaxAndMin(input);
    shift2ZeroNeu();
    GetNormRate();
    NormValue(&input);
    WidenNeutral(&input);
    CutInvalidInput(&input);
    return input;
}