#include "mbed.h"

#define PIN_MOTOR_TACH_INPUT p9

Serial con(USBTX, USBRX);
Timer tc;

int tach_pulse_period;

void handler(void){
    tc.stop();
    tach_pulse_period = tc.read_us();
    tc.reset();
    tc.start();
}

int main() {
    
    InterruptIn tach(PIN_MOTOR_TACH_INPUT);
    tach.fall(handler);
    
    tc.reset();
    tc.start();
    
    con.baud(9600);
    con.printf("init\r\n");
    while(1) {
        con.printf("%d [us]\r\n", tach_pulse_period);
        wait_ms(100);
    }
}
