//define common data

#ifndef AGZ_COMMON
#define AGZ_COMMON

#include "XBee.h"
#include "mbed.h"

//device num with XBee
#define AGZ_NUM_NODES   56

//about robot
#define AGZ_NUM_ROBOTS  4//40
#define AGZ_FROM_ROBOT  0
#define AGZ_TO_ROBOT    39

//about base
#define AGZ_FROM_BASE   40
#define AGZ_TO_BASE     47
#define AGZ_BASE_A_FROM_ROBOT_ID    0
#define AGZ_BASE_A_TO_ROBOT_ID      7
#define AGZ_BASE_B_FROM_ROBOT_ID    8  
#define AGZ_BASE_B_TO_ROBOT_ID      15
#define AGZ_BASE_C_FROM_ROBOT_ID    16
#define AGZ_BASE_C_TO_ROBOT_ID      23 

//about joy-stick
#define AGZ_FROM_JOY    48
#define AGZ_TO_JOY    55

/*----------------------------------------------------------
    data of Xbee
-----------------------------------------------------------*/
//Addres List 
extern XBeeAddress64 Agz_XBee_Remote_Address[AGZ_NUM_ROBOTS];



/*----------------------------------------------------------
    data of ROBOT
-----------------------------------------------------------*/
union AGZ_UNION_INT8_LONG{
    uint8_t value_ch[4];
    long    value_long;   
};

class AGZ_ROBOT{
private:
    uint8_t state;
    AGZ_UNION_INT8_LONG LatitudeH,LatitudeL, LongitudeH,LongitudeL;  
    AGZ_UNION_INT8_LONG LatitudeKH,LatitudeKL, LongitudeKH,LongitudeKL;  
public:
    AGZ_ROBOT();
    void set_state(uint8_t);
    void set_LatitudeH(uint8_t*);    
    void set_LatitudeL(uint8_t*);    
    void set_LongitudeH(uint8_t*);    
    void set_LongitudeL(uint8_t*);    
    uint8_t get_state();
    long get_LatitudeH();    
    long get_LatitudeL();    
    long get_LongitudeH();    
    long get_LongitudeL();    
    void set_LatitudeKH(uint8_t*);    
    void set_LatitudeKL(uint8_t*);    
    void set_LongitudeKH(uint8_t*);    
    void set_LongitudeKL(uint8_t*);    
    long get_LatitudeKH();    
    long get_LatitudeKL();    
    long get_LongitudeKH();    
    long get_LongitudeKL();    
};

/*----------------------------------------------------------
    data of BASE
-----------------------------------------------------------*/


/*----------------------------------------------------------
    data of JOY-STICK
-----------------------------------------------------------*/




#endif