#include "agz_common.h"
#include "XBee.h"



/*XBee Address List
* this is xbee addresses. 
* AGZ_ROBOT Address is Agz_XBee_Remote_Address[AGZ_FROM_ROBOT] ~ Agz_XBee_Remote_Address[AGZ_TO_ROBOT] 
* Base and JOY-STICK is same.
*/

XBeeAddress64 Agz_XBee_Remote_Address[AGZ_NUM_ROBOTS] = {XBeeAddress64(0x0013A200, 0x409EAEF3)//R1
                                                        ,XBeeAddress64(0x0013A200, 0x40993719)//R2
                                                        ,XBeeAddress64(0x0013A200, 0x409EAEEB)//R3
                                                        ,XBeeAddress64(0x0013A200, 0x409EAF0E)};//R4
                                                        /*
                                                        {XBeeAddress64(0x0013A200, 0x409EAF01)
                                                        ,XBeeAddress64(0x0013A200, 0x409EAF01)
                                                        ,XBeeAddress64(0x0013A200, 0x409EAF01)
                                                        ,XBeeAddress64(0x0013A200, 0x409EAF01)};
*/


/*----------------------------------------------
 member function of "AGZ_ROBOT"
------------------------------------------------*/
//set function
AGZ_ROBOT::AGZ_ROBOT(){
    state = 0xFF;
}

void AGZ_ROBOT::set_state(uint8_t s){
    state = s;
}

void AGZ_ROBOT::set_LatitudeH(uint8_t *data){
    for(int i = 0;i < 3;i++)
        LatitudeH.value_ch[i] = data[i];
}

void AGZ_ROBOT::set_LatitudeL(uint8_t *data){
    for(int i = 0;i < 6;i++)
        LatitudeL.value_ch[i] = data[i];
}

void AGZ_ROBOT::set_LongitudeH(uint8_t *data){
    for(int i = 0;i < 3;i++)
        LongitudeH.value_ch[i] = data[i];
}

void AGZ_ROBOT::set_LongitudeL(uint8_t *data){
    for(int i = 0;i < 6;i++)
        LongitudeL.value_ch[i] = data[i];
}


//get function
long AGZ_ROBOT::get_LatitudeH(){
    return LatitudeH.value_long;
}

long AGZ_ROBOT::get_LatitudeL(){
    return LatitudeL.value_long;
}

long AGZ_ROBOT::get_LongitudeH(){
    return LongitudeH.value_long;
}

long AGZ_ROBOT::get_LongitudeL(){
    return LongitudeL.value_long;
}
uint8_t AGZ_ROBOT::get_state(){
    return state;
}


void AGZ_ROBOT::set_LatitudeKH(uint8_t *data){
    for(int i = 0;i < 3;i++)
        LatitudeKH.value_ch[i] = data[i];
}

void AGZ_ROBOT::set_LatitudeKL(uint8_t *data){
    for(int i = 0;i < 6;i++)
        LatitudeKL.value_ch[i] = data[i];
}

void AGZ_ROBOT::set_LongitudeKH(uint8_t *data){
    for(int i = 0;i < 3;i++)
        LongitudeKH.value_ch[i] = data[i];
}

void AGZ_ROBOT::set_LongitudeKL(uint8_t *data){
    for(int i = 0;i < 6;i++)
        LongitudeKL.value_ch[i] = data[i];
}


//get function
long AGZ_ROBOT::get_LatitudeKH(){
    return LatitudeKH.value_long;
}

long AGZ_ROBOT::get_LatitudeKL(){
    return LatitudeKL.value_long;
}

long AGZ_ROBOT::get_LongitudeKH(){
    return LongitudeKH.value_long;
}

long AGZ_ROBOT::get_LongitudeKL(){
    return LongitudeKL.value_long;
}
