#include "mbed.h"
#include "VNH5019.h"

#ifndef AIGAMOZU_CONTROL_PACKETS
#define AIGAMOZU_CONTROL_PACKETS

#define MANUAL_COMMAND_LENGTH 17
#define REQUEST_COMMNAD_LENGTH 11
#define CHANGE_MODE_COMMAND_LENGTH 12
#define RECEIVE_STATUS_COMMNAD_LENGTH 64

#define vertex2D vector2D

#define BASENUMBER 10
#define speed 96

enum COMMAND_TYPE {MANUAL = 'M', STATUS_REQUEST = 'S', CHANGE_MODE = 'C', RECEIVE_STATUS = 'R',RECEIVE_KALMAN = 'K'};
enum MODE {STANDBY_MODE = 0, MANUAL_MODE = 1, AUTO_MODE = 2, AUTO_GPS_MODE = 3};
enum STATUS {GPS_AVAIL = 0, GPS_UNAVAIL = 1, GPS_OUT_AREA = 2};

class AigamozuControlPackets
{
    //--------PRIVATE-----------//
private:
    VNH5019 _agzSheild;

    MODE nowMode;
    STATUS nowStatus;
    bool out_flag;

    union UNION_double_char {
        double double_value;
        uint8_t char_value[8];
    };

    struct vector2D {
        double x;
        double y;
    };

    uint8_t* packetData;
    int packetLength;

    // 割り込み
    Ticker eachModeInt;

    //自分自身の位置の情報（double型）
    vector2D agzPoint;
    //ベースの位置の情報（double型）
    vector2D basePoint[BASENUMBER];

    //--------PUBLIC-----------//
public:
    AigamozuControlPackets(VNH5019 agzSheild);
    
    vector2D sub_vector(vector2D A, vector2D B);
    bool checkInOut(vector2D A, vector2D B, vector2D C, vector2D P);
    void autoMoving(void);

    // Create Packet: Robot -> Base, Manager -> Robot/Base
    void createRequestCommand(uint8_t fromID, uint8_t toID);

    // Create Packet: Base -> Robot/Manager, Robot -> Manager
    void createReceiveStatusCommand(uint8_t fromID, uint8_t toID, int state);

    // update data
    void reNewRobotPoint(long latitudeH, long latitudeL, long longitudeH, long longitudeL);
    void reNewBasePoint(int id, uint8_t *latitude, uint8_t *longitude);

    // Manual Mode
    void manualMode(void);

    // Change Mode
    void changeMode(uint8_t *buf);

    // set
    void set_nowStatus(STATUS s);

    // get
    MODE get_nowMode(void);
    uint8_t* get_packetData(void);
    int get_packetLength(void);
    bool get_out_flag(void);
    double get_agzPoint_latitude(void);
    double get_agzPoint_longitude(void);
    double get_basePoint_latitude(int i);
    double get_basePoint_longitude(int i);

};
#endif