#include "mbed.h"
#include "VNH5019.h"

#ifndef AIGAMOZU_CONTROL_PACKETS
#define AIGAMOZU_CONTROL_PACKETS

#define MANUAL_COMMAND_LENGTH 17
#define REQUEST_COMMNAD_LENGTH 11
#define CHANGE_MODE_COMMAND_LENGTH 12
#define RECEIVE_STATUS_COMMNAD_LENGTH 64

enum COMMAND_TYPE {MANUAL = 'M', STATUS_REQUEST = 'S', CHANGE_MODE = 'C', RECEIVE_STATUS = 'R',RECEIVE_KALMAN = 'K'};
enum MODE {STANDBY_MODE = 0, MANUAL_MODE = 1,AUTO_MODE = 2,AUTO_GPS_MODE = 3};
enum STATUS {GPS_AVAIL = 0, GPS_UNAVAIL = 1,GPS_OUT_AREA = 2};

class AigamozuControlPackets{
    
    //--------PUBLIC-----------//
    public:
    AigamozuControlPackets(VNH5019 agzSheild);
    
    Ticker eachModeInt;
    
    uint8_t* packetData;
     
    //using create packet
    uint8_t* getPacketData();
    int getPacketLength();
    
    //Change Mode: 
    bool changeMode(uint8_t *buf); 
    
    //Check Command Type using xbee buffer;
    uint8_t checkCommnadType(uint8_t* buf);
    
    //Change Speed
    void changeSpeed(uint8_t* buf);
    
    MODE nowMode;
    char motorCommand;
    STATUS nowStatus;
    int packetLength;
    
    //Auto Type 2 -> GPS    
    bool autoMove(/*const int autobase[]*/void);
    void controlMotor(int);
    Timer moveTimer;

    //--------PRIVATE-----------//
    private:
    //
    VNH5019 _agzSheild;
    
    void manualMode();
    int manualCount;
   
    };
    
#endif