#include "mbed.h"
#include "ADXL345_I2C.h"

 
ADXL345_I2C acc(p9, p10);
Serial pc(USBTX, USBRX);

void ADXL345_settings(){
    //Go into standby mode to configure the device.
    acc.setPowerControl(0x00);
    wait(0.001);
 
    //Full resolution, +/-16g, 4mg/LSB.
    acc.setDataFormatControl(0x09);
    wait(0.001);
     
    //3.2kHz data rate.
    acc.setDataRate(ADXL345_800HZ);
    wait(0.001);
 
    //Measurement mode.
    acc.setPowerControl(0x08);
    wait(0.001);
}
 
int main()
{
    wait(3);
    
    pc.baud(9600);
 
    int readings[3] = {0, 0, 0};
    
    Timer acc_Timer;
    const int acc_Time = 100;
    
    acc_Timer.start();
     
  pc.printf("Starting ADXL345 test...\n");
    wait(0.001);
    ADXL345_settings();        
    wait(0.1);
       
    while(true){ 
    
    if(acc_Timer.read_ms() >= acc_Time){
        acc_Timer.reset();
        acc.getOutput(readings);
        pc.printf("%i %i %i\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);   
    }
    }
}
