#include "mbed.h"
#include "SparkfunAnalogJoystick.h"
#include "uLCD_4DGL.h"

#define M_PI 3.14159265358979323846

SparkfunAnalogJoystick joysttick(p18, p19, p20);
uLCD_4DGL lcd(p13, p14, p15);

// Test program for the library
// It would output all data about the joystick
// It would also draw a compass to indicate the joystick status on the LCD display

int main() {
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    float lastx=0;
    float lasty=0;
    while(1) {
        printf("X-Axis: %f\n\r", joysttick.xAxis());
        printf("Y-Axis: %f\n\r", joysttick.yAxis());
        printf("Angle: %f\n\r", joysttick.angle());
        printf("Distance: %f\n\r", joysttick.distance());
        printf("Button: %d\n\r\n", joysttick.button());
        float distance=joysttick.distance();
        float angle=joysttick.angle();
        float x=distance*cos(angle*M_PI/180)*40;
        float y=distance*sin(angle*M_PI/180)*40;
        printf("y: %f\n\r\n", y);
        lcd.circle(60, 60, 40, WHITE);
        lcd.line(60, 60, 60+lastx, 60-lasty, BLACK);
        lcd.line(60, 60, 60+x, 60-y, WHITE);
        lastx=x;
        lasty=y;     
        wait(0.1);
    }
}
