/*
 * TaskMove.h
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#ifndef TASK_MOVE_H_
#define TASK_MOVE_H_

#include <cstdlib>
#include "Controller.h"
#include "Task.h"

/**
 * This is a specific implementation of a task class that moves the robot with given velocities.
 */
class TaskMove : public Task {
    
    public:
        
        static const float  DEFAULT_DURATION;   /**< Default duration, given in [s]. */
        
                    TaskMove(Controller& controller, float translationalVelocity, float rotationalVelocity);
                    TaskMove(Controller& controller, float translationalVelocity, float rotationalVelocity, float duration);
        virtual     ~TaskMove();
        virtual int run(float period);
        
    private:
        
        Controller& controller;             // reference to controller object to use
        float       translationalVelocity;  // translational velocity, given in [m/s]
        float       rotationalVelocity;     // rotational velocity, given in [rad/s]
        float       duration;               // duration to move the robot, given in [s]
        float       time;                   // current time, given in [s]
};

#endif /* TASK_MOVE_H_ */

