/*
 * Main.cpp
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 */

#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "IRSensor.h"
#include "IMU.h"
#include "LIDAR.h"
#include "Controller.h"
#include "StateMachine.h"
#include "SerialServer.h"

int main() {
    
    // create miscellaneous periphery objects
    
    DigitalOut led(LED1);
    DigitalIn button(USER_BUTTON);
    
    DigitalOut led0(PC_8);
    DigitalOut led1(PC_6);
    DigitalOut led2(PB_12);
    DigitalOut led3(PA_7);
    DigitalOut led4(PC_0);
    DigitalOut led5(PC_9);
    
    // create motor control objects
    
    DigitalOut enableMotorDriver(PB_2);
    DigitalIn motorDriverFault(PB_14);
    DigitalIn motorDriverWarning(PB_15);
    
    PwmOut pwmLeft(PA_8);
    PwmOut pwmRight(PA_9);
    
    EncoderCounter counterLeft(PB_6, PB_7);
    EncoderCounter counterRight(PA_6, PC_7);
    
    // create distance sensor objects
    
    DigitalOut enableIRSensors(PC_1);
    enableIRSensors = 1;
    
    AnalogIn distance(PB_1);
    DigitalOut bit0(PH_1);
    DigitalOut bit1(PC_2);
    DigitalOut bit2(PC_3);
    
    IRSensor irSensor0(distance, bit0, bit1, bit2, 0);
    IRSensor irSensor1(distance, bit0, bit1, bit2, 1);
    IRSensor irSensor2(distance, bit0, bit1, bit2, 2);
    IRSensor irSensor3(distance, bit0, bit1, bit2, 3);
    IRSensor irSensor4(distance, bit0, bit1, bit2, 4);
    IRSensor irSensor5(distance, bit0, bit1, bit2, 5);
    
    // create LIDAR object
    
    PwmOut pwm(PA_10);
    pwm.period(0.00005f);
    pwm.write(0.5f);      // 50% duty-cycle
    
    RawSerial uart(PA_0, PA_1);
    
    LIDAR lidar(uart);
    
    // create robot controller objects
    
    Controller controller(pwmLeft, pwmRight, counterLeft, counterRight);
    StateMachine stateMachine(controller, enableMotorDriver, led0, led1, led2, led3, led4, led5, button, irSensor0, irSensor1, irSensor2, irSensor3, irSensor4, irSensor5);
    
    // create serial server object
    
    RawSerial serial(PB_10, PC_5);
    serial.baud(9600);
    serial.format(8, SerialBase::None, 1);
    
    DigitalOut reset(PB_3);
    DigitalOut modes1(PB_4);
    
    modes1 = 0;
    
    reset = 1; wait(0.1f);
    reset = 0; wait(0.1f);
    reset = 1; wait(0.1f);
    
    SerialServer serialServer(serial, lidar, controller);
    printf("Started\n");
    while (true) {
        
        led = !led; // toggle led
        
        wait(0.2f); // wait for 200 ms
        
        lidar.lookForBeacon();
    }
}

