/*
 test OLED module (128x64/SPI) [aitendo VGM12864SPI-W]
*/

#include "mbed.h"

#include "ssd1306.h"
#include "standard_font.h"
#include "bold_font.h"

 SSD1306 oled(p8 /* cs */, p9 /* reset */, p10 /* dc */, p7 /* clock */, p5 /* data */); // LPC1768
// SSD1306 oled(PTA13 /* cs */, PTD5 /* reset */, PTD0 /* dc */, PTD1 /* clock */, PTD2 /* data */); // KL25Z
//SSD1306 oled(D10 /* cs */, D9 /* reset */, D8 /* dc */, D13 /* clock */, D11 /* data */); // KL05Z or Arduino styles
Serial pc(USBTX, USBRX);      

#define NUMFLAKES 10
#define XPOS 0
#define YPOS 1
#define DELTAY 2

#define LOGO16_GLCD_HEIGHT 48 
#define LOGO16_GLCD_WIDTH  48 

static const unsigned char  logo64_glcd_bmp[] =
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00
,0x00,0x00,0x01,0xff,0xff,0x80,0x00,0x00
,0x00,0x00,0x0f,0x80,0x01,0xf0,0x00,0x00
,0x00,0x00,0x3c,0x00,0x00,0x78,0x00,0x00
,0x00,0x00,0x70,0x00,0x00,0x0e,0x00,0x00
,0x00,0x01,0xe0,0x00,0x00,0x07,0x00,0x00
,0x00,0x03,0x80,0x00,0x00,0x01,0xc0,0x00
,0x00,0x07,0x00,0x00,0x00,0x00,0xe0,0x00
,0x00,0x0e,0x00,0x00,0x00,0x00,0x70,0x00
,0x00,0x1c,0x00,0x00,0x00,0x00,0x38,0x00
,0x00,0x38,0x00,0x00,0x00,0x00,0x18,0x00
,0x00,0x30,0x00,0x00,0x00,0x00,0x0c,0x00
,0x00,0x60,0x00,0x00,0x00,0x00,0x06,0x00
,0x00,0xc0,0x00,0x00,0x00,0x00,0x06,0x00
,0x00,0xc0,0x00,0x00,0x00,0x00,0x03,0x00
,0x01,0x80,0x00,0x00,0x00,0x00,0x01,0x80
,0x01,0x80,0x00,0x00,0x00,0x00,0x01,0x80
,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0
,0x03,0x00,0x0c,0x00,0x00,0x20,0x00,0xc0
,0x06,0x00,0x3f,0x00,0x01,0xfc,0x00,0x40
,0x06,0x00,0x73,0x80,0x03,0x8e,0x00,0x60
,0x06,0x00,0xc0,0xc0,0x03,0x06,0x00,0x60
,0x04,0x00,0xc0,0xc0,0x06,0x02,0x00,0x20
,0x0c,0x00,0xc0,0x40,0x06,0x02,0x00,0x30
,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x30
,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x30
,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x30
,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x30
,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10
,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10
,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10
,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10
,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10
,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10
,0x08,0x00,0x60,0x00,0x00,0x04,0x00,0x30
,0x0c,0x00,0x60,0x00,0x00,0x04,0x00,0x30
,0x0c,0x00,0x60,0x00,0x00,0x04,0x00,0x30
,0x0c,0x00,0x20,0x00,0x00,0x04,0x00,0x30
,0x0c,0x00,0x30,0x00,0x00,0x0c,0x00,0x20
,0x04,0x00,0x30,0x00,0x00,0x0c,0x00,0x60
,0x06,0x00,0x30,0x00,0x00,0x08,0x00,0x60
,0x06,0x00,0x18,0x00,0x00,0x18,0x00,0x60
,0x02,0x00,0x18,0x00,0x00,0x18,0x00,0xc0
,0x03,0x00,0x0c,0x00,0x00,0x30,0x00,0xc0
,0x03,0x00,0x0e,0x00,0x00,0x60,0x00,0x80
,0x01,0x80,0x07,0x00,0x00,0xe0,0x01,0x80
,0x01,0x80,0x03,0x80,0x01,0xc0,0x03,0x00
,0x00,0xc0,0x01,0xe0,0x07,0x80,0x03,0x00
,0x00,0x60,0x00,0x78,0x3e,0x00,0x06,0x00
,0x00,0x60,0x00,0x1f,0xf8,0x00,0x0e,0x00
,0x00,0x30,0x00,0x03,0xc0,0x00,0x0c,0x00
,0x00,0x18,0x00,0x00,0x00,0x00,0x18,0x00
,0x00,0x0c,0x00,0x00,0x00,0x00,0x30,0x00
,0x00,0x06,0x00,0x00,0x00,0x00,0x60,0x00
,0x00,0x03,0x00,0x00,0x00,0x00,0xc0,0x00
,0x00,0x01,0xc0,0x00,0x00,0x03,0x80,0x00
,0x00,0x00,0xe0,0x00,0x00,0x07,0x00,0x00
,0x00,0x00,0x78,0x00,0x00,0x1e,0x00,0x00
,0x00,0x00,0x1e,0x00,0x00,0x78,0x00,0x00
,0x00,0x00,0x07,0xe0,0x07,0xe0,0x00,0x00
,0x00,0x00,0x01,0xff,0xff,0x00,0x00,0x00
,0x00,0x00,0x00,0x1f,0xf8,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
 };
 
  static const unsigned char  logoeye_bmp[] ={
 0x00,0x00,0x00,0x80,0x00,0x00,0x00
,0x00,0x00,0x10,0x81,0x00,0x00,0x00
,0x00,0x04,0x10,0x81,0x04,0x00,0x00
,0x00,0x04,0x10,0x81,0x04,0x10,0x00
,0x00,0x84,0x10,0x81,0x04,0x30,0x00
,0x00,0x86,0x10,0x83,0x0c,0x30,0x00
,0x00,0x82,0x10,0xc2,0x08,0x20,0x00
,0x20,0xc2,0x18,0xc2,0x18,0x60,0x80
,0x30,0xc3,0x18,0xc2,0x18,0x40,0x80
,0x10,0x61,0x18,0x02,0x10,0xc1,0x80
,0x18,0x61,0x10,0x00,0x10,0xc1,0x00
,0x08,0x21,0x07,0xfc,0x00,0x83,0x00
,0x0c,0x30,0xfc,0x07,0xe0,0x86,0x00
,0x06,0x03,0xe1,0xf0,0xfc,0x0c,0x00
,0x03,0x1e,0x0f,0x0e,0x0f,0x08,0x00
,0x00,0x78,0x18,0x03,0x01,0xc0,0x00
,0x00,0xe0,0x18,0x01,0x00,0xe0,0x00
,0x01,0xc0,0x30,0x01,0x80,0x30,0x00
,0x03,0x00,0x20,0xf0,0x80,0x1c,0x00
,0x06,0x00,0x21,0xf0,0x80,0x0e,0x00
,0x0c,0x00,0x23,0xf8,0xc0,0x03,0x00
,0x0c,0x00,0x23,0xf8,0xc0,0x03,0x00
,0x0e,0x00,0x21,0xf8,0xc0,0x06,0x00
,0x07,0x00,0x20,0xf0,0x80,0x0c,0x00
,0x01,0x80,0x30,0x00,0x80,0x38,0x00
,0x00,0xe0,0x10,0x01,0x80,0x60,0x00
,0x00,0x78,0x0c,0x03,0x01,0xc0,0x00
,0x00,0x3c,0x0c,0x06,0x07,0x80,0x00
,0x00,0x07,0xc3,0xf8,0x3e,0x00,0x00
,0x00,0x01,0xf8,0x01,0xf0,0x00,0x00
,0x00,0x00,0x1f,0xff,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
 
 static const unsigned char  logopops_bmp[] =
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0xff,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x03,0xff,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x07,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x0f,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x1f,0xff,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x3f,0xff,0xff,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x3f,0xc0,0x3f,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x7f,0x80,0x1f,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0xff,0x00,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0xfe,0x00,0x07,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0xfc,0x00,0x03,0xf0,0x38,0x3c,0x20,0x8c,0xf8,0xf0,0xf0,0x88
,0x00,0x00,0x03,0xf0,0x3c,0x7e,0x20,0xcc,0xf8,0xf8,0xf8,0xcc
,0x00,0x00,0x03,0xf0,0x26,0x66,0x20,0x48,0x30,0xc1,0x98,0xcc
,0x00,0x00,0x03,0xf0,0x3c,0x66,0x20,0x70,0x20,0xf1,0x98,0xfc
,0x00,0x00,0x03,0xf0,0x38,0x7e,0x3c,0x30,0x20,0xf1,0xf8,0xcc
,0xfc,0x00,0x03,0xf0,0x20,0x3c,0x3c,0x30,0x20,0xf0,0xf0,0x88
,0xfe,0x00,0x07,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0xff,0x00,0x0f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0xff,0x00,0x0f,0xe0,0x31,0x19,0x30,0xe5,0x30,0x00,0x00,0x00
,0xff,0xc0,0x3f,0xe0,0x2a,0x95,0x40,0x85,0x28,0x00,0x00,0x00
,0xff,0xf0,0x7f,0xc0,0x3a,0x9d,0x30,0xe5,0x2c,0x00,0x00,0x00
,0xff,0xff,0xff,0xc0,0x23,0x95,0x08,0x25,0x2c,0x00,0x00,0x00
,0xff,0xff,0xff,0x80,0x22,0x95,0x30,0xe7,0x38,0x00,0x00,0x00
,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0xff,0xff,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0xfc,0xff,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x7c,0x3f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

 static const unsigned char  logoclose_bmp[] ={
0x00,0x00,0x3f,0xfe,0x00,0x00,0x00
,0x00,0x03,0xe0,0x07,0xe0,0x00,0x00
,0x00,0x1f,0x00,0x00,0xf8,0x00,0x00
,0x00,0x78,0x00,0x00,0x0f,0x00,0x00
,0x00,0xe0,0x00,0x00,0x07,0x80,0x00
,0x01,0x80,0x00,0x00,0x01,0xc0,0x00
,0x07,0x00,0x00,0x00,0x00,0x60,0x00
,0x0c,0x00,0x00,0x00,0x00,0x38,0x00
,0x18,0x00,0x00,0x00,0x00,0x1c,0x00
,0x30,0x00,0x00,0x00,0x00,0x0c,0x00
,0x30,0x00,0x00,0x00,0x00,0x0c,0x00
,0x1c,0x00,0x00,0x00,0x00,0x18,0x00
,0x0e,0x00,0x00,0x00,0x00,0x30,0x00
,0x03,0x00,0x00,0x00,0x00,0xe0,0x00
,0x01,0xc0,0x00,0x00,0x01,0xc0,0x00
,0x03,0xe0,0x00,0x00,0x07,0xe0,0x00
,0x07,0xfc,0x00,0x00,0x1f,0xf0,0x00
,0x06,0x7c,0x00,0x00,0x1e,0x30,0x00
,0x0c,0x6f,0xc0,0x01,0xf3,0x18,0x00
,0x18,0x43,0xf8,0x0f,0xe3,0x0c,0x00
,0x30,0x42,0x1f,0xfe,0x21,0x04,0x00
,0x20,0xc2,0x18,0xc2,0x21,0x86,0x00
,0x60,0xc2,0x10,0xc6,0x21,0x82,0x00
,0x40,0x86,0x10,0xc6,0x30,0xc3,0x00
,0x41,0x86,0x10,0xc6,0x10,0xc1,0x00
,0x01,0x04,0x10,0xc2,0x10,0x40,0x00
,0x03,0x0c,0x30,0x43,0x18,0x40,0x00
,0x03,0x08,0x20,0x43,0x08,0x40,0x00
,0x02,0x08,0x20,0x41,0x08,0x00,0x00
,0x00,0x08,0x20,0x41,0x08,0x00,0x00
,0x00,0x00,0x20,0x41,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

 static const unsigned char  oeil_bmp[] ={
0x0e,0x00,0x1f,0x00,0x3f,0x80,0x71,0xc0
,0x64,0xc0,0x7f,0xc0,0x7f,0xc0,0x3f,0x80
,0x1f,0x00,0x0e,0x00,0x00,0x00
};
static const unsigned char test1[]={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x3f,0xff,0xc0,0x0,0x0,0x0,0x0,0x3,0xff,0xfc,0x0,0x0,0x0,
0x0,0x0,0x0,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,0xf,0xff,0xff,0x0,0x0,0x0,
0x0,0x0,0x3,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xc0,0x0,0x0,
0x0,0x0,0x3,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xc0,0x0,0x0,
0x0,0x0,0x7,0xff,0xff,0xfe,0x0,0x0,0x0,0x0,0x7f,0xff,0xff,0xe0,0x0,0x0,
0x0,0x0,0x7,0xff,0xff,0xfe,0x0,0x0,0x0,0x0,0x7f,0xff,0xff,0xe0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xf0,0x0,0x0,
0x0,0x0,0x7,0xff,0xff,0xfe,0x0,0x0,0x0,0x0,0x7f,0xff,0xff,0xe0,0x0,0x0,
0x0,0x0,0x7,0xff,0xff,0xfe,0x0,0x0,0x0,0x0,0x7f,0xff,0xff,0xe0,0x0,0x0,
0x0,0x0,0x3,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xc0,0x0,0x0,
0x0,0x0,0x3,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xc0,0x0,0x0,
0x0,0x0,0x0,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,0xf,0xff,0xff,0x0,0x0,0x0,
0x0,0x0,0x0,0x3f,0xff,0xc0,0x0,0x0,0x0,0x0,0x3,0xff,0xfc,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};


 static const unsigned char  oeilvide_bmp[] ={
0x00,0x00,0x00,0x80,0x00,0x00,0x00
,0x00,0x00,0x10,0x81,0x00,0x00,0x00
,0x00,0x04,0x10,0x81,0x04,0x00,0x00
,0x00,0x04,0x10,0x81,0x04,0x10,0x00
,0x00,0x84,0x10,0x81,0x04,0x30,0x00
,0x00,0x86,0x10,0x83,0x0c,0x30,0x00
,0x00,0x82,0x10,0xc2,0x08,0x20,0x00
,0x20,0xc2,0x18,0xc2,0x18,0x60,0x80
,0x30,0xc3,0x18,0xc2,0x18,0x40,0x80
,0x10,0x61,0x18,0x02,0x10,0xc1,0x80
,0x18,0x61,0x10,0x00,0x10,0xc1,0x00
,0x08,0x21,0x07,0xfc,0x00,0x83,0x00
,0x0c,0x30,0xfc,0x07,0xe0,0x86,0x00
,0x06,0x03,0xc0,0x00,0x7c,0x0c,0x00
,0x03,0x1e,0x00,0x00,0x0f,0x08,0x00
,0x00,0x78,0x00,0x00,0x01,0xc0,0x00
,0x00,0xe0,0x00,0x00,0x00,0xe0,0x00
,0x01,0xc0,0x00,0x00,0x00,0x30,0x00
,0x03,0x00,0x00,0x00,0x00,0x1c,0x00
,0x06,0x00,0x00,0x00,0x00,0x0e,0x00
,0x0c,0x00,0x00,0x00,0x00,0x03,0x00
,0x0c,0x00,0x00,0x00,0x00,0x03,0x00
,0x0e,0x00,0x00,0x00,0x00,0x06,0x00
,0x07,0x00,0x00,0x00,0x00,0x0c,0x00
,0x01,0x80,0x00,0x00,0x00,0x38,0x00
,0x00,0xe0,0x00,0x00,0x00,0x60,0x00
,0x00,0x78,0x00,0x00,0x01,0xc0,0x00
,0x00,0x3c,0x00,0x00,0x07,0x80,0x00
,0x00,0x07,0xc0,0x00,0x3e,0x00,0x00
,0x00,0x01,0xf8,0x01,0xf0,0x00,0x00
,0x00,0x00,0x1f,0xff,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

static const unsigned char happy1_bmp[] ={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char happy2_bmp[] ={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char happy3_bmp[] ={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char happy4_bmp[] ={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char happy5_bmp[] ={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x7f,0xfe,0x0,0x0,0x7f,0xfe,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3,0xff,0xff,0xc0,0x3,0xff,0xff,0xc0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3,0xff,0xff,0xc0,0x3,0xff,0xff,0xc0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x7f,0xfe,0x0,0x0,0x7f,0xfe,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char happy6_bmp[] ={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3,0xff,0xff,0xc0,0x0,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x1,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x3,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x7,0xff,0xff,0xfe,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x7,0xff,0xff,0xfe,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x3,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x1,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3,0xff,0xff,0xc0,0x0,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char happy7_bmp[] ={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x3,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x7,0xff,0xff,0xfe,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xff,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char sceptique2_bmp []={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char sceptique3_bmp []={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char sceptique4_bmp []={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x3,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x7f,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0xf,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x1f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

static const unsigned char sceptique5_bmp []={
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x0,0x1,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x0,0x7f,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x0,0x1f,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x7,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x1f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x3f,0xff,0xff,0xfc,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x3f,0xff,0xff,0xfc,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1f,0xff,0xff,0xf8,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0xf,0xff,0xff,0xf0,0x1f,0xff,0xff,0xf8,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0xf,0xff,0xff,0xf0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x7,0xff,0xff,0xe0,0x7,0xff,0xff,0xe0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x1,0xff,0xff,0x80,0x3,0xff,0xff,0xc0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x1f,0xf8,0x0,0x0,0x3f,0xfc,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};



void testdrawline() {  
  for (int16_t i=0; i<SSD1306_LCDWIDTH; i+=4) {
    oled.line(0, 0, i, SSD1306_LCDHEIGHT-1);
    oled.update();
  }
  for (int16_t i=0; i<SSD1306_LCDHEIGHT; i+=4) {
    oled.line(0, 0, SSD1306_LCDWIDTH-1, i);
    oled.update();
  }
  wait(0.25); // delay(250);
  
  oled.clear();
  for (int16_t i=0; i<SSD1306_LCDWIDTH; i+=4) {
    oled.line(0, SSD1306_LCDHEIGHT-1, i, 0);
    oled.update();
  }
  for (int16_t i=SSD1306_LCDHEIGHT-1; i>=0; i-=4) {
    oled.line(0, SSD1306_LCDHEIGHT-1, SSD1306_LCDWIDTH-1, i);
    oled.update();
  }
  wait(0.25); // delay(250);
  
  oled.clear();
  for (int16_t i=SSD1306_LCDWIDTH-1; i>=0; i-=4) {
    oled.line(SSD1306_LCDWIDTH-1, SSD1306_LCDHEIGHT-1, i, 0);
    oled.update();
  }
  for (int16_t i=SSD1306_LCDHEIGHT-1; i>=0; i-=4) {
    oled.line(SSD1306_LCDWIDTH-1, SSD1306_LCDHEIGHT-1, 0, i);
    oled.update();
  }
  wait(0.25); // delay(250);

  oled.clear();
  for (int16_t i=0; i<SSD1306_LCDHEIGHT; i+=4) {
    oled.line(SSD1306_LCDWIDTH-1, 0, 0, i);
    oled.update();
  }
  for (int16_t i=0; i<SSD1306_LCDWIDTH; i+=4) {
    oled.line(SSD1306_LCDWIDTH-1, 0, i, SSD1306_LCDHEIGHT-1); 
    oled.update();
  }
  wait(0.25);
}

int main()
{
    oled.initialise();
    oled.clear();
    oled.set_contrast(255); 
    oled.update();
    // max contrast
    // oled.clear();
     /*   oled.drawBitmap((128/2-48),0,test1, 128, 64);
        oled.update();
        
   /* oled.drawBitmap(32, 0,  poulet, 64, 64);
    //oled.drawBitmap(32, 0,  logo64_glcd_bmp, 64, 64);
    oled.update();*/
    /*
    wait(3);
    oled.clear();
        oled.drawBitmap(-16,0,test1, 128, 64);
        oled.update();
    */
     // oled.clear();
        /*oled.drawBitmap(0,0,happy1_bmp, 128, 64);
        oled.update();
        wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique2_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique3_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique4_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique5_bmp, 128, 64);
        oled.update();
        */
    int j=1;
    int jd,jg;
    

while(1){    

    if(pc.readable()){
            char dir;
            dir=pc.getc();

    //for(int i=0;i<(128);i=i+j){
            //oled.drawBitmap(i,0,  logo2_bmp, 94, 32);
            /*jg= ((i<=11) ? 11 : (i>=28 ? 28 : i));
            jd=  ((i<=(11+127-50)) ? (11+127-50): (i>=(28+127-50) ? (28+127-50) : i));
            */
    switch (dir){
        case 'g' :
        oled.clear();
        oled.drawBitmap(-16,0,test1, 128, 64);
        oled.update();
        break;
        case 'd':
        oled.clear();
        oled.drawBitmap((128/2-48),0,test1, 128, 64);
        oled.update();
        break;
        case'h':
        oled.drawBitmap(0,0,happy1_bmp, 128, 64);
        oled.update();
        wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,happy2_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,happy3_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,happy4_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,happy5_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,happy6_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,happy7_bmp, 128, 64);
        oled.update();
       break;
       case 's':
       oled.drawBitmap(0,0,happy1_bmp, 128, 64);
        oled.update();
        wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique2_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique3_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique4_bmp, 128, 64);
        oled.update();
         wait(0.1);
        oled.clear();
        oled.drawBitmap(0,0,sceptique5_bmp, 128, 64);
        oled.update();
       
       
        default:
        
        break;
        
         
        
      //  for (int i=-16;i<(128/2-48);i=i+j){
                
                
                //oled.drawBitmap(i,0,test1, 128, 64);
                /*
                oled.drawBitmap(0,0,oeilvide_bmp, 50, 32);
                oled.drawBitmap(127-50,0,oeilvide_bmp, 50, 32);
                oled.drawBitmap(jg,15,oeil_bmp, 11, 11);
                oled.drawBitmap(jd,15,oeil_bmp, 11, 11);
                */
                /*
                oled.drawBitmap(11,15,oeil_bmp, 11, 11);
                oled.drawBitmap(11+127-50,15,oeil_bmp, 11, 11);
                */
              
                
        /*          if(jj>0) {
                    oled.drawBitmap(0,0,  logoeye_bmp, 50, 32);
                    oled.drawBitmap(127-50,0,  logoeye_bmp, 50, 32);
                }else{
                    oled.drawBitmap(0,0,  logoclose_bmp, 50, 32);
                    oled.drawBitmap(127-50,0,  logoclose_bmp, 50, 32);
                }
        */             
              //oled.drawBitmap(i,32,  logopops_bmp, 94, 32);
              //oled.d
              //  oled.update();
               // wait(0.01); 
               // oled.clear();
               // j=((i==(128/2-48))||((j==-1)&&(i==0)) ? -j : j);
             //  j=((i==(128/2-48)||(i==0)) ? -j : j);
        //}
        }
    }
}
    int i = 0;
   
    while (1) {
   
    }
}

// EOF