#include "mbed.h"
#include "ContinuousServo.h"
#include "Tach.h"

ContinuousServo left(p23);
ContinuousServo right(p26);
AnalogIn sonar(p19);
Ticker ultra;
Serial pc(USBTX,USBRX);

float wall = 100.0;
float analog;
float range;

void update() {
    wall = 2.3*156.25*sonar.read();
    pc.printf("%f\r\n", wall);
}
 
int main() {
    ultra.attach(&update, 0.1);
    wait(3);
    
    while(wall>=12.0) { // main code for driving goes here
    left.speed(.2);
    right.speed(-.2);
    }
    left.stop();
    right.stop();
}