//ES202 FINAL PROJECT: LARREA, MOUAFFAK

#include "mbed.h"
#include "ContinuousServo.h"
#include "Tach.h"
#include "TCS3472_I2C.h"

ContinuousServo left(p23);
ContinuousServo right(p26);
AnalogIn sonar(p19);
PwmOut LB(p22); // PWM out signal to power LED on the sensor
TCS3472_I2C rgb_sensor( p9, p10 ); // Establish RGB sensor object
DigitalOut hallpwr(p22);
InterruptIn hall(p21);
DigitalOut flash(LED4);
Ticker ultra;
Serial pc(USBTX,USBRX);

float wall = 100.0;
float analog;
float range;

int rgb_data[4]; // declare a 4 element array to store RGB sensor readings
float PWMbrightness = 1.0; // float specifying brightness of LED (between 0.0 and 1.0)
int x = 0;
float a,b,c;

void update()
{
    a = 2.3*156.25*sonar.read();
    wait(0.01);
    b = 2.3*156.25*sonar.read();
    wait(0.01);
    c = 2.3*156.25*sonar.read();
    wait(0.01);
    wall = (a+b+c)/3.0;
}

void sweep()
{
    x = x+1;
    hallpwr = 0;
    wait(0.2);
    hallpwr = 1;
    flash = 1;
    wait(0.5);
    flash = 0;
    
}
    
int main()
{
    ultra.attach(&update, 0.1);

    hall.mode(PullUp);
    hallpwr = 1;
    hall.rise(&sweep);
    
    rgb_sensor.enablePowerAndRGBC(); // Enable RGB sensor
    rgb_sensor.setIntegrationTime(100); // Set integration time of sensor

    wait(3);

    while(wall>=6.9) { // main code for driving goes here

        LB = PWMbrightness; // set brightness of sensor LED
        rgb_sensor.getAllColors( rgb_data );
//        pc.printf("%d\r\n", rgb_data[1]);
        left.speed(.12);
        right.speed(-.22);
        if(rgb_data[1]<900) {
            left.speed(.09);
            right.speed(-.22);
        } else if(rgb_data[1]>1000) {
            left.speed(.16);
            right.speed(-.15);
        } else{
            left.speed(.12);
            right.speed(-.22);
        }
    }
    left.stop();
    right.stop();
}