#include "mbed.h"
#include "Servo.h"
#include "ultrasonic.h"


void dist(int distance)
{
    //put code here to execute when the distance has changed
    printf("Distance %d mm\r\n", distance);
}

Servo myservo(D9);
Serial pc(SERIAL_TX, SERIAL_RX);

ultrasonic mu(D8, D10, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                         //have updates every .1 seconds and a timeout after 1
                                         //second, and call dist when the distance changes
                                         
//-------------------------------------------------------------------------------------------------
 int main() {
     
     myservo.calibrate (0.001, 45.0);   // kalibracja serva
     mu.startUpdates();                 //start measuring the distance
 
     while(1) {
         for(int i=(-25); i<35; i++) {
             myservo.position(i);
             wait(0.5);
             printf("Pozycja %d ", i);
             mu.checkDistance();
         }
         for(int i=35; i>(-25); i--) {
             myservo.position(i);
             wait(0.5);
             printf("Pozycja %d ", i);
             mu.checkDistance();
         }
     }
 }