#ifndef THUMBSTICK_H
#define THUMBSTICK_H

#include "mbed.h"

#define deadzone 0.125f

class Thumbstick
{
public:
    //Creates a Thumbstick object with two alanlog pins and one digital
    Thumbstick(PinName lR, PinName uD, PinName b);
    
    //call this all the time, yo
    void update();
    
    //Is the thumbstick left
    int left();
    //Is the thumbstick right
    int right();
    
    //Is the thumbstick up
    int up();
    //Is the thumbstick down
    int down();
    
    //Is the center button pressed
    int button();
    
private:
    //The two inputs for left/right and up/down, respectively
    AnalogIn LeftRight;
    AnalogIn UpDown;
    
    //An input for for the center click button
    DigitalIn Button;
    
    //Whether the thumbstick or button was active or not in the last update
    int leftLast;
    int rightLast;
    int upLast;
    int downLast;
    int buttonLast;
    
    //Whether the thumbstick or button is active currently
    int leftCurr;
    int rightCurr;
    int upCurr;
    int downCurr;
    int buttonCurr;
    
};

#endif