#include "Thumbstick.h"

Thumbstick :: Thumbstick(PinName lR, PinName uD, PinName b):LeftRight(lR), UpDown(uD), Button(b), leftCurr(0), rightCurr(0), upCurr(0), downCurr(0), buttonCurr(0)
{
    
}

void Thumbstick :: update()
{
    leftLast   = leftCurr;
    rightLast  = rightCurr;
    upLast     = upCurr;
    downLast   = downCurr;
    buttonLast = buttonCurr;
    
    leftCurr   = (LeftRight <= deadzone);
    rightCurr  = (LeftRight >= (1.0 - deadzone));
    upCurr     = (UpDown    <= deadzone);
    downCurr   = (UpDown    >= (1.0 - deadzone));
    buttonCurr = !Button;
}

int Thumbstick :: left()
{
    return leftCurr && (!leftLast);
}

int Thumbstick :: right()
{
    return rightCurr && (!rightLast);
}

int Thumbstick :: up()
{
    return upCurr && (!upLast);
}

int Thumbstick :: down()
{
    return downCurr && (!downLast);
}

int Thumbstick :: button()
{
    return buttonCurr && (!buttonLast);
}