#ifndef NFC_h
#define NFC_h

#include "mbed.h"
#include "NFCTag.h"

class NFC
{
public:
    //Create an NFC object with the given sda and scl lines
    NFC(PinName sda, PinName scl, PinName NFCIRQ, char NFCAddress);
    //Read an NFC tag into an NFCTag object
    bool readNFCTag(NFCTag* tag);
    //Write a tag from an NFCTag object
    bool writeNFCTag(NFCTag* tag);
    
    
private:
    //The I2C object for communication with the NFC antenna
    I2C bus;
    
    //The address of the NFC antenna
    char address;
    
    //The pin that the IRQ line is on
    DigitalIn interrupt;
    
    char pn532_packetbuffer[64];
    
    void progStatus(char status, int waitMs = 1000);
    char checkBusy(void);
    char readAck(void);
    void wireReadData(char* buff, char n);
    char sendCommand(char* cmd, char cmdlen);
    char sendCommandCheckAck (char* cmd, char cmdlen, int timeout = 0);
    char SAMConfig(void);
    char readPassiveTargetID(char cardbaudrate, char * uid, char * uidLength, char timeout = 0);
    char mifareclassic_AuthenticateBlock (char * uid, char uidLen, int blockNumber, char keyNumber, char * keyData);
    char mifareclassic_WriteDataBlock (char blockNumber, char * data);
    char mifareclassic_ReadDataBlock (char blockNumber, char * data);
    
};

#endif