#ifndef MENUSTATEMACHINE_H
#define MENUSTATEMACHINE_H

#include "AMC1602.h"
#include "Thumbstick.h"
#include "State.h"
#include "StateMachine.h"
#include "NFC.h"

#include "mbed.h"
//Forward declarations of functions so that each function can see other functions(?)
void startUp(void);

void mainMenu(void);

void readTag(void);
void writeTag(void);
void options(void);

void readTagSuccess(void);

//Declaring states with their respective functions
State StartUp(startUp);

State MainMenu(mainMenu);

State ReadTag(readTag);
State WriteTag(writeTag);
State Options(options);

State ReadTagSuccess(readTagSuccess);

//State machine with starting point
StateMachine Menu(&StartUp);

//Declaration of any globals blah
Thumbstick thumby(p20, p19, p17);
AMC1602 screen(p28, p27, 0x78);
NFC device(p28, p27, p5, 0x48);
NFCTag taglesworth;

int day = 11;
int month = 12;
int year = 15;

//Implimentation of functions
void startUp(void)
{
    taglesworth.setString("MILK      151212");
    screen.print("Start Up                        ");
    wait(1);
    Menu.nextState = &MainMenu;
}

void mainMenu(void)
{
    static int mainMenuValue = 0;
    char *mainMenuOptions[3]={"Read A Tag     >","Write A Tag    >","Options        >"};
    State *nextStates[3] ={&ReadTag,&WriteTag,&Options};
    thumby.update();
    wait_ms(10);
    if(thumby.down())
    {
        mainMenuValue = (mainMenuValue+1)%3;
    }
    if(thumby.up())
    {
        mainMenuValue = (mainMenuValue+2)%3;
    }
    if(thumby.right() || thumby.button())
    {
        Menu.nextState = nextStates[mainMenuValue];
    }
    screen.printTop("Main Menu^V     ");
    screen.printBottom(mainMenuOptions[mainMenuValue]);
}

void readTag(void)
{
    static int millisecondsLeft = 10000;
    char bottomString1[16] = {'W','a','i','t','i','n','g','.','.','.',' ',' ',' ',' ','0','9'};
    char bottomString2[16] = {'F','o','r',' ','T','a','g','.','.','.',' ',' ',' ',' ','0','9'};
    
    thumby.update();
    
    
    
    //No need for the wait because of how long it takes for an NFC non-read to timeout
    //Kept this here so you know why this works when the code seems like it shouldn't
    //wait_ms(100);
    millisecondsLeft -= 100;
    
    
    
     
    
    bottomString1[15] = bottomString2[15] = (millisecondsLeft/1000) + '0';
    
    if(millisecondsLeft <= 0)
    {
        Menu.nextState = &MainMenu;
        millisecondsLeft = 10000;
    }
    
    screen.printTop("Read A Tag      ");
    
    device.writeNFCTag(&taglesworth);
    
    if(device.readNFCTag(&taglesworth))
    {
        Menu.nextState = &ReadTagSuccess;
    }
    
    
    if(millisecondsLeft % 2000 < 1000)
    {
        screen.printBottom(bottomString1);
    }
    else
    {
        screen.printBottom(bottomString2);
    }
    if(thumby.left())
    {
        Menu.nextState = &MainMenu;
        millisecondsLeft = 10000;
    }
}

void writeTag(void)
{
    thumby.update();
    wait_ms(10);
    screen.print("Write A Tag                     ");
    if(thumby.left())
    {
        Menu.nextState = &MainMenu;
    }
}

void options(void)
{
    thumby.update();
    wait_ms(10);
    screen.print("Options                         ");
    if(thumby.left())
    {
        Menu.nextState = &MainMenu;
    }
}

void readTagSuccess(void)
{
    static int millisecondsLeft = 6000;
    
    int expired = 2;
    
    
    if(taglesworth.Year() < year)
    {
        expired = 1;
    }
    else if(taglesworth.Year() > year)
    {
        expired = 0;
    }
    else
    {
        if(taglesworth.Month() < month)
        {
            expired = 1;
        }
        else if(taglesworth.Month() > month)
        {
            expired = 0;
        }
        else
        {
            if(taglesworth.Day() <= day)
            {
                expired = 1;
            }
            else if(taglesworth.Day() > day)
            {
                expired = 0;
            }
        }
    }
    
    thumby.update();
    wait_ms(100);
    millisecondsLeft -= 100;
    
    if(millisecondsLeft <= 0)
    {
        millisecondsLeft = 6000;
    }
    
    char topString[16];
    char bottomString[16];
    
    if(expired == 1)
    {
        if(millisecondsLeft % 2000 < 1000)
        {
            taglesworth.getName(topString);
            
            bottomString[0] = taglesworth.itemString[12];
            bottomString[1] = taglesworth.itemString[13];
            bottomString[2] = '/';
            bottomString[3] = taglesworth.itemString[14];
            bottomString[4] = taglesworth.itemString[15];
            bottomString[5] = '/'; 
            bottomString[6] = taglesworth.itemString[10];
            bottomString[7] = taglesworth.itemString[11];
            
            //Fill them gaps up with spaces, yo
            for(int i = 8; i < 16; ++i)
            {
                topString[i] = ' ';
                bottomString[i] = ' ';
            }
        }
        else
        {
            for(int i = 0; i < 16; ++i)
            {
                topString[i] = "Item Expired    "[i];
                bottomString[i] = "<  Main Menu   >"[i];
            }
        }
    }
    else if (expired == 0)
    {
        int MonthsUntilExpired = taglesworth.Month() - month;
        int DaysUntilExpired = taglesworth.Day() - day;
        int YearsUntilExpired = taglesworth.Year() - year;
        
        if(millisecondsLeft % 3000 < 1000)
        {
            for(int i = 0; i < 16; ++i)
            {
                topString[i] = ("     Store Tag?>")[i];
                bottomString[i] = ("<Main Menu      ")[i];
            }
        }
        else if(millisecondsLeft % 3000 < 2000)
        {
            for(int i = 0; i < 16; ++i)
            {
                topString[i] = ("Expires in:     ")[i];
                bottomString[i] = (" __ y __ m __ d ")[i];
            }
            bottomString[1] = (YearsUntilExpired / 10) + '0';
            bottomString[2] = (YearsUntilExpired % 10) + '0';
            
            bottomString[6] = (MonthsUntilExpired / 10) + '0';
            bottomString[7] = (MonthsUntilExpired % 10) + '0';
            
            bottomString[11] = (DaysUntilExpired / 10) + '0';
            bottomString[12] = (DaysUntilExpired % 10) + '0';
        }
        else
        {
            taglesworth.getName(topString);
            
            bottomString[0] = taglesworth.itemString[12];
            bottomString[1] = taglesworth.itemString[13];
            bottomString[2] = '/';
            bottomString[3] = taglesworth.itemString[14];
            bottomString[4] = taglesworth.itemString[15];
            bottomString[5] = '/'; 
            bottomString[6] = taglesworth.itemString[10];
            bottomString[7] = taglesworth.itemString[11];
            
            //Fill them gaps up with spacres, yo
            for(int i = 8; i < 16; ++i)
            {
                topString[i] = ' ';
                bottomString[i] = ' ';
            }
        }
    }
    
    screen.printTop(topString);
    screen.printBottom(bottomString);
    
    if(thumby.left())
    {
        Menu.nextState = &MainMenu;
        millisecondsLeft = 10000;
    }
}

#endif