#ifndef AMC1602_H
#define AMC1602_H

#include "mbed.h"

class AMC1602
{
public:
    //Create an AMC1602 object on the I2C pins:(sda, scl), with the I2C address:(screenAddress) 
    AMC1602(PinName sda, PinName scl, char screenAddress);
    
    //print whatever's in the textBuffer onto the screen
    void print();
    
    //print two lines from a 32 character string
    void print(char* message);
    
    //print the top line from a 16 character string
    void printTop(char* message);
    
    //print the bottom line from a 16 character string
    void printBottom(char* message);
    
    
    //BITMAP FUNCTIONS
    //NO GARUNTEES OF WORKING
    
    //read a bitmap with the string filename
      //returns a  string of the file contents (top left corner first)
    char* readBitmap(char* filename);
    
    //read a bitmap with the string file contents buffer(80x16)
    void printBitmap(char* buffer);
    
    //get a character from an images buffer
    void getChar(char* buffer, int x, int y);
    
    
private:
    //The I2C object used for sneding data to the screen
    I2C bus;
    
    //The I2C address of the screen
    char address;
    
    //a buffer of the charcters to be written
    char textBuffer[32];
    
    //Buffer of all the bitmap (monochrome) data to be printed to the screen
    //16 characters wide, each 5 pixels, with 15 pixel spaces between
    //2 charcters tall, with a 1 pixel space between
    //8 bits in a char
    char imageBuffer[320];
};
#endif