#include "AMC1602.h"

//Create an AMC1602 object on the I2C pins:(sda, scl), with the I2C address:(screenAddress) 
AMC1602 :: AMC1602(PinName sda, PinName scl, char screenAddress):bus(sda, scl), address(screenAddress)
{
    char cb[2] = {0x00,0x38};
    
    wait_ms(50);
    bus.write(address, cb, 2);
        
    cb[1] = 0x0c;
        
    wait_us(150);
    bus.write(address, cb, 2);
        
    cb[1] = 0x01;
        
    wait_us(150);
    bus.write(address, cb, 2);
        
    cb[1] = 0x06;
        
    wait_ms(15);
    bus.write(address, cb, 2);
    wait_us(150);
    for(int i = 0; i < 32; ++i)
    {
        textBuffer[i] = 0xFF;
    }
}

//print whatever's in the textBuffer onto the screen
void AMC1602 :: print()
{
    //command mode, set cursor to origin
    char cb[2] = {0x00, 0x02};
    bus.write(address, cb, 2);
    
    //data mode
    cb[0] = 0x40;
    
    for(int i = 0; i<16; ++i)
    {
        cb[1] = textBuffer[i];
        bus.write(address, cb, 2);
    }
    for(int i = 0; i<(40-16); ++i)
    {
        cb[1] = 0xFF;
        bus.write(address, cb, 2);
    }
    for(int i = 16; i<32; ++i)
    {
        cb[1] = textBuffer[i];
        bus.write(address, cb, 2);
    }
}
    
//print two lines from a 32 character string
void AMC1602 :: print(char* str)
{
    for(int i = 0; i<32; ++i)
    {
        textBuffer[i] = str[i];
    }
    
    print();
}
    
//print the top line from a 16 character string
void AMC1602 :: printTop(char* str)
{
    for(int i = 0; i<16; ++i)
    {
        textBuffer[i] = str[i];
    }
    
    print();
}
    
//print the bottom line from a 16 character string
void AMC1602 :: printBottom(char* str)
{
    for(int i = 16; i<32; ++i)
    {
        textBuffer[i] = str[i-16];
    }
    
    print();
}





//BITMAP FUNCTIONS
    //NO GARUNTEES OF WORKING
    
//read a bitmap with the string filename
  //returns a  string of the file contents (top left corner first)
char* AMC1602::readBitmap(char* filename)
{
}
    
//read a bitmap with the string file contents buffer(80x16)
void AMC1602::printBitmap(char* buffer)
{
    
}




































































