/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Proyecto Ensamblado Baño Automático
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
                Camacho Camacho Fermín Rodrigo
                Luna Villanueva Julio Daniel
                Sánchez Zarazua Edgar Omar
**          - 
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define     TRUE            1
#define     FALSE           0
#define     On              0
#define     off             1 
#define     hold            2           // Estado para boton mantenido
#define     release         3           // Estado para boton liberado
#define     Ticker_Time     1000        // Tiempo del Ticker (us)
#define     Rate_Time       2           // Tiempo de Encendido de los Digitos (ms)
#define     Scan_Time       2           // Tiempo de Barrido del Display (ms)
#define     Shift_Time      2           // Tiempo de corrimiento  (x Counter_Time)
#define     Counter_Time    100         // Tiempo de counter (ms)
#define     Size_String     13          // Tamaño del Buffer de Caracteres
#define     Digit_Null      0xFF        // Valor para apagar los Segmentos 
#define     Degree_Symbol   0x0F        // Valor para el Símbolo de Grados
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker     Barrido;                     // Interrupción del Timer
BusOut     Anodos(PTA14, PTA15, PTA16, PTA17); // Salidas a los anodos del display: A4 A3 A2 A1
BusOut     Catodos(PTE16, PTE17, PTE18, PTE19, PTE20, PTE21, PTE22, PTE23); // Salidas a los catodos: g f a b c d e p
DigitalOut Green_Led (PTD5);            // Led de Actividad del Programa
DigitalOut Red_Led   (PTE29);           // Led de Actividad del Programa

DigitalIn Selector_seguro(PTD3);
DigitalIn Limit_switch(PTB20);
DigitalOut Ventilador(PTD4);  //Relé
DigitalOut Luz(PTD7);       //Relé
DigitalOut Seguro(PTD6); //Relé
DigitalOut Red(PTE6);
DigitalOut Green(PTE3);
DigitalOut Blue(PTE2);
DigitalOut Buzzer(PTE31);

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=325; // 1000us=1ms
uint8_t cont_1ms=0;
uint8_t cont_10ms=0;
uint8_t cont_100ms=0;
uint8_t cont_1s=0;
bool Flag1=FALSE;
bool Flag2=FALSE;                  
  
                    //Para el DISPLAY de 7 segmentos:
/*Para CATODO COMUN:
//            0    1    2    3    4    5    6    7    8    9    A    b    C    d    E    f    G    h    I    j    K    L    M    n    o    p    q    r    S    t    u    v    w    X    y    z
//uint8_t Segmentos[]={0x7F,0x18,0xB6,0xBC,0xD8,0xEC,0xEE,0x38,0xFE,0xFC,0xFA,0xCE,0x66,0x9E,0xE6,0xE2,0x6E,0xCA,0x42,0x1C,0xD2,0x46,0x7A,0x8A,0x8E,0xF2,0xF8,0xC2,0xEC,0xC6,0x0E,0x1E,0x5E,0xDA,0xC8,0xB6};
//      Millares,Centenas,Decenas,Unidades
//uint8_t Digitos[]={0x0E, 0x0D, 0x0B, 0x07};
// Para descomponer el valor en multiplos
//Multiplos[]={Millares,Centenas,Decenas,Unidades}
Utilizar C.I. 74LS126 como Latch para c/u de los segmentos del Display*/


//Para ANODO COMUN:
//                    0    1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18   19   20   21   22   23   24   25   26   27   28   29   30  31   32   33   34    35  36    37   
//                    0    1    2    3    4    5    6    7    8    9    A    b    C    d    E    f    G    h    I    j    K    L    M    n    o    p    q    r    S    t    u    v    w    X    y    z  space  -
uint8_t Segmentos[]={0x81,0xE7,0x49,0x43,0x27,0x13,0x11,0xC7,0x01,0x03,0x05,0x31,0x99,0x61,0x19,0x1D,0x91,0x35,0xBD,0xB3,0x2D,0xB9,0x85,0x75,0x71,0x0D,0x07,0x3D,0x13,0x39,0xF1,0xE1,0xA1,0x25,0x37,0x49,0xFF,0x7F};
//              Millares,Centenas,Decenas,Unidades
uint8_t Digitos[]={0x01, 0x02, 0x04, 0x08, 0x00, 0xFF};
// Para descomponer el valor en multiplos
//Multiplos[]={Millares,Centenas,Decenas,Unidades}
//Utilizar C.I. 74LS125 como Latch para c/u de los segmentos del Display           
uint8_t Mensaje1[]={36,36,24,12,30,25,10,13,24,36,36,36,36}; // MENSAJE         "  Ocupado   "
uint8_t Mensaje2[]={36,36,13,18,28,25,24,23,18,11,21,14,36}; // MENSAJE         "  Disponible  "
uint8_t Mensaje3[]={36,36,11,18,14,23,31,14,23,18,13,24,36}; // MENSAJE         "  Bienvenido  "
uint8_t Numeros[]={36,36,36,36,36,11,10,23,24,36,36,36,36};   //MENSAJE INICIAL "     Bano     "
uint8_t Cadena[]={36,11,18,14,23,31,14,23,18,13,24,36,36}; //BUFFER             " Bienvenidos  "
uint8_t  scan_rate = Scan_Time ;
uint8_t  shift_rate= Shift_Time;
uint16_t counter=1250;
uint8_t  i=0;
uint8_t  nchar=0;
bool     flag1=FALSE;
bool     flag2=FALSE;
bool     mode=0;
uint8_t  punto_decimal=0;   //Posición del Punto Decimal: 0=sin punto, 1=unidades, 2=decenas, 3=centemas 4=millares, 
uint8_t control=0;
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void); 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
bool BanoDisponible(void);
bool BanoOcupado(void);
bool PuertaAbierta(void);
void Display(void);
void Mensaje(void);
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/

//////////////////////////////  PROGRAMA PRINCIPAL  //////////////////////////////////////////
int main()
{ 
    Buzzer=1;
    wait(0.020);
    Buzzer=0;
    Red=0;
    Blue=1;
    Green=0;
    wait(0.5);
  Barrido.attach_us(&Barrido_OnInterrupt, Rate);   // Le asigna el periodo de barrido cada 10 ms
  while(true)
  { 
    if(Limit_switch==1 && Selector_seguro==0)
    { //Puerta Cerrada (BAÑO DISPONIBLE)
        Seguro=0;           //Seguro desactivado
        BanoDisponible();
    }
    if(Limit_switch==1 && Selector_seguro==1)
    { //Puerta Cerrada (BAÑO OCUPADO)
        Seguro=1;           //Seguro activado
        BanoOcupado();
    }
    if(Limit_switch==0 && Selector_seguro==0)
    {  //Puerta Abierta
      Seguro=0; //Desactivado
      PuertaAbierta();
    }
// LLama al Barrido del Display
if (flag1==TRUE)
        {
                if (mode==1)
                {
                    Numeros[i]=Cadena[i+nchar];             // Aqui está el ptroblema!!!!
                    if (nchar >= Size_String) nchar=0;   // Restablece el contador de caractres
                    if (i==4)
                    {
                        i=0;    
                        mode=0;         // Nos vamos a modo 0
                    }                         
                } 
            Anodos=Digitos[4];          // Apaga todos los Digitos (Evita fantasmas)                
            Catodos=Segmentos[Numeros[i]];  // Actualiza los segmentos
            if (i==4) Catodos=(Segmentos[Numeros[i]]& 0xFE); // Enciende el punto decimal
            Anodos=Digitos[i];          // Activa el Digito en cuestión
            i++;                        // Apunta al siguiente dígito
            if (i==4)                   // Es el últino digito?
            {
                i=0;                    // Reinicia el Barriodo
                mode=0;                 // Nos vamos a modo 0
                Red_Led=!Red_Led;       // Parpadeo del Led Rojo
            }    
            flag1=FALSE;                // Apaga la Bandera 1
        }    
       if (flag2==TRUE)                 // Está puesta la Bandera 2?
       {
        shift_rate--;                   // Decrementa el contador de Corrimientos
        if (!shift_rate)                // Es Cero?
        {    
            mode=1;                     // Tiempo entre desplazamientos del mensaje
            shift_rate = Shift_Time;    // Restablece el triempo de los corrimientos
            nchar++;                    // corrimiento al siguiente conjunto de de caracteres
            i=0;                        // Restablece el índice para comenzar el Barrido
        } 
           Green_Led=!Green_Led;        // Parpadeo del Led Verde
           flag2=FALSE;                 // Apaga la Bandera 2
       } 
    }
  // END while
}
// END main

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt(void)              // Rutina de Atención al Ticker
{                          //El servicio a la interrupcion van aqui!
 cont_1ms++;
    scan_rate++;
    counter--;
    if(scan_rate==4)
    {
        scan_rate=0;          
        flag1=TRUE;
    }        
    if (cont_1ms>=10)
    {
        cont_10ms++;
        cont_1ms=0;
    }      
    if (cont_10ms>=10)
    {
        cont_100ms++;
        cont_10ms=0;
    }    
    if (cont_100ms>=10)
    {
        cont_1s++;
        cont_100ms=0;
    }    
    if (cont_1s>=10) 
    {
        cont_1s=0;
    }
    if (!counter)
    {
        counter=300;
        flag2=TRUE;            
    }
}
/* END Events */        // Rutinas de Atención a Interrupciones


////////////////////////// BARRIDO DEL DISPLAY  ////////////////////////////////////
void Display()
{
// Barrido del Display //    
    /*if (Flag2==TRUE)
    {
        
        Anodos=Digitos[4];      // Evita Fantasmas       
        Catodos=Segmentos[copia[i]];
        Anodos=Digitos[i]; 
        i++;
        if (i==4)
        {            //PROBLEMA?
            i=0;   
             
        }          
       Flag1=FALSE;        
    }    */               
}           
// End Display 

////////////////////////// FUNCIONES ESTADO DEL BAÑO  ////////////////////////////////////
bool BanoDisponible()
{
      Luz=0; 
      Ventilador=0;     //Luz y entilador apagados
      Seguro=0;         //Seguro desactivado       
      Green=0;  
      Red=1;
      Blue=1; 
      control=2;
      Mensaje(); 
      return true;
}

bool BanoOcupado()
{
      Luz=1; 
      Ventilador=1; //Luz y ventilador encendidos
      Seguro=1;     // Seguro Activado
      Red=0;
      Green=1;
      Blue=1;
      control=1;
      Mensaje();
      return true;
}
      
bool PuertaAbierta()
{
      Luz=1;
      Ventilador=1;
      Green=1;  
      Red=0;
      Blue=0;
      control=3;
      Mensaje();
      return true;
}
////////////////////////// MENSAJES  ////////////////////////////////////
void Mensaje()
{
    //corrimiento de mensaje// 
    switch (control)
    {
      case 1:   
        for(uint8_t o=0;o<=13;o++){
            Cadena[o] = Mensaje1[o];
        }
        break;
      case 2:   
        for(uint8_t o=0;o<=13;o++){
            Cadena[o] = Mensaje2[o];
        }
        break;  
      case 3:   
        for(uint8_t o=0;o<=13;o++){
            Cadena[o] = Mensaje3[o];
        }
        break;
    }
} 
// END Mbed