/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Generate WAVE Signal - 25/04/2018                %
% Arkadi Rafalovich - % Arkadiraf@gmail.com         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Updates:
% Disable interrupt during chirp out, fixes systic interrupt delays at 1ms interval for 0.5 us
Pinout:
DAC -- PA_4 -- A2

I/O -- PA_5 -- D13 (Status LED, Condition)
I/O -- PA_6 -- D12 (Toggle Pin, Loop Freq)
Analog PA_0 -- A0  (Potentiometer)

*/
#include "mbed.h"
#include "signal.h"
#define PULSE_RATE 10.0f // in HZ
#define FREQ_POT_EN // Potentiometer to set PULSE Rate
#define MIN_FREQ 0.1f //(HZ)
#define SAMPLE_RATE_375_KHZ // basic sample rate is 1Mhz, this mode adds delay in between sample to meet the audio sample rate

float pulseRate=PULSE_RATE;
// Serial over USB as input device
Serial pc(SERIAL_TX, SERIAL_RX);

// mbed variables, Settings
AnalogOut out(PA_4);
AnalogIn potFreq(A0);
// Potentiometer analog INPUT

// digital pins
DigitalOut led(LED1);
DigitalOut outPulse(PA_6); // Toggle pin, Loop Freq

// User Button as interrupt
DigitalIn mybutton(USER_BUTTON);

//DAC declarations
DAC_HandleTypeDef hdac1;

// Dac Register for direct method of setting DAC value`s
__IO uint32_t Dac_Reg = 0;

// Variables
bool toggle_state=0;

// nop operation
inline void NOP()
{
    __ASM volatile ("nop");    // one tick operation, Use to adjust frequency by slowing down the proccess
}

/* DAC1 init function */
void DAC1_Init(void);

// Main procedure
int main()
{
    DAC1_Init();

    HAL_DAC_Start(&hdac1, DAC_CHANNEL_1);

    // define Dac Register for direct method of setting DAC value`s
    Dac_Reg = (uint32_t) (hdac1.Instance);
    Dac_Reg += __HAL_DHR12R1_ALIGNEMENT(DAC_ALIGN_12B_R);

    // set outputs
    outPulse.write(0);
    led.write(0);
    // Output value using DAC
    // HAL_DAC_SetValue(&hdac1, DAC_CHANNEL_1, DAC_ALIGN_12B_R, ADCValueOut);
    *(__IO uint32_t *) Dac_Reg = (uint16_t)(4095/2);

    // Infinite loop
    while(true) {
        if (mybutton.read()==0) { // if button pressed, generate pulse out
            led.write(1);

            /////////////////////////////////////////////////////////////////////////////////
            __disable_irq();    // Disable Interrupts
            // generate chirp out
            for (int ii=0; ii<NUM_SAMPLES; ii++) {
                // toogle io for loop frequency
                toggle_state=!toggle_state;
                outPulse.write(toggle_state);
                // generate delay for 1MHz Sample rate
                for (int jj=0; jj<31; jj++) {
                    NOP();
                }
                // micro nops :)
                NOP();
                NOP();
                NOP();
                NOP();
                NOP();
                NOP();
                NOP();
                
                #ifdef SAMPLE_RATE_375_KHZ
                // generate delay
                for (int jj=0; jj<61; jj++) {
                    NOP();
                }
                // micro nops :)
                //NOP();
                //NOP();
                NOP();
                NOP();
                NOP();
                #endif
                // Output value using DAC
                // HAL_DAC_SetValue(&hdac1, DAC_CHANNEL_1, DAC_ALIGN_12B_R, ADCValueOut);
                *(__IO uint32_t *) Dac_Reg = chirpData[ii];
            }
            // Output value using DAC
            // HAL_DAC_SetValue(&hdac1, DAC_CHANNEL_1, DAC_ALIGN_12B_R, ADCValueOut);
            *(__IO uint32_t *) Dac_Reg = (uint16_t)(4095/2);
            __enable_irq();     // Enable Interrupts
            //////////////////////////////////////////////////////////////////////////////////

            // generate delay between pulses
            // delay post pulse // sets the pulse rate
            float waitTime = (1.0f/(2.0f*pulseRate) - (((float)NUM_SAMPLES)/1000000.0f));
            if (waitTime > 0) {
                led.write(0);
                wait(waitTime);
                led.write(1);
                wait(1.0f/(2.0f*pulseRate));
            } else {
                wait(0.5);
                printf("!!! Error Wait time is negative %f !!!\r\n", waitTime);
                wait(0.5);
            }
        } // end button press
        led.write(0);

        // update freq based on potentiometer
#ifdef FREQ_POT_EN 
        pulseRate = potFreq * PULSE_RATE;
        if (pulseRate < MIN_FREQ) pulseRate = MIN_FREQ;
        //printf("Pulse Rate %f\r\n", pulseRate);     
#endif
    }// end while(True)
}


// init dac

/* DAC1 init function */
void DAC1_Init(void)
{
    DAC_ChannelConfTypeDef sConfig;

    // DAC Initialization
    hdac1.Instance = DAC;
    if(HAL_DAC_Init(&hdac1) != HAL_OK) {
        printf("!!! Error in DAC initialization !!!\r\n");
    }

    // DAC channel OUT1 config
    sConfig.DAC_Trigger = DAC_TRIGGER_NONE;
    sConfig.DAC_OutputBuffer = DAC_OUTPUTBUFFER_ENABLE;
    if (HAL_DAC_ConfigChannel(&hdac1, &sConfig, DAC_CHANNEL_1) != HAL_OK) {
        printf("!!! Error in DAC channel initialization !!!\r\n");
    }
}
