////////////////////////////////////////
//      Tau_ReSpeaker_DSP_Test        //
//  Arkadiraf@gmail.com - 29/05/2017  //
////////////////////////////////////////
/*
 If button pressed --> generate sine wave else analog output = analog input
*/

/*
   Board : Nucleo STM32F446RE
   Power Source : USB
*/

/*
    Pinout:
    PC - Serial 2
    PA_2 (Tx) --> STLINK
    PA_3 (Rx) --> STLINK

    Switch - Serial 3
    PC_10 (Tx) --> SW_Rx
    PC_11 (Rx) --> SW_Tx

    I2C_Bus
    PB_8 --> SCL
    PB_9 --> SDA

    Digital output
    PA_5 --> led (DigitalOut)

    Digital Input
    PA_10 --> SW_Trigger
    PC_13 --> BTN (Blue)

    Analog Input
    PA_0 --> SIG_IN_DSP

    Analog Output
    PA_4 --> SIG_OUT_DSP

*/

///////////////
// Libraries //
///////////////
#include "mbed.h"
#include "BufferedSerial.h"  // solves issues of loosing data. alternative doing it yourself

///////////////
// #defines  //
///////////////

#define DEBUG_MOD1

// Sine generator
#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)
#define BUFFER_SIZE (360)

/////////////
// Objects //
/////////////

// uart
BufferedSerial pc(USBTX, USBRX);

// digital
DigitalIn user_button(PC_13);
DigitalIn sw_trigger(PA_10);
DigitalOut led(PA_5);

// analog
AnalogOut dsp_output(PA_4);
AnalogIn dsp_input(PA_0);

///////////////
// variables //
///////////////

// analog input
uint16_t adc_in=0;

// sin wave buffer
uint16_t buffer[BUFFER_SIZE];
uint16_t buffer_index=0;
///////////////
// Functions //
///////////////

// Create the sinewave buffer
void calculate_sinewave(void);

////////////////////////
//  Main Code Setup : //
////////////////////////
int main()
{
    pc.baud(57600);
#ifdef DEBUG_MOD1
    pc.printf("ReSpeaker Test \r\n");
#endif
    // calculate sine wave buffer
    calculate_sinewave();

    ///////////////////////
    //  Main Code Loop : //
    ///////////////////////
    while(1) {
        // check button state
        if (user_button) {
            //adc_in=dsp_input.read_u16();
            dsp_output.write_u16(dsp_input.read_u16()); //adc_in
        } else {
            // sinewave output
            buffer_index++;
            if (buffer_index>=BUFFER_SIZE) buffer_index=0;
            dsp_output.write_u16(buffer[buffer_index]);
            wait_us(1);
        }
    }
}

///////////////
// Functions //
///////////////

// Create the sinewave buffer
void calculate_sinewave(void)
{
    for (int i = 0; i < BUFFER_SIZE; i++) {
        double rads = (PI * i)/180.0; // Convert degree in radian
        buffer[i] = (uint16_t)(AMPLITUDE * (RANGE * (cos(rads + PHASE))) + OFFSET);
    }
}