////////////////////////////////////////
//      Tau_ReSpeaker_PGA_Test        //
//  Arkadiraf@gmail.com - 31/10/2017  //
////////////////////////////////////////
/*
 Receive byte from pc for settings
 byyyyxxxx - y- Set PGA gain , x- select channle
 Realterm mode Binary, send message 0xYX (Hex format)
*/

/*
   Board : Nucleo STM32F303k8
*/

/*
    Pinout:
    PC - Serial 2
    PA_2 (Tx)  --> STLINK
    PA_15 (Rx) --> STLINK

    SPI PGA112:
    PB_5  --> MOSI (DIO)
    PB_4  --> MISO (DIO N.C.)
    PB_3  --> SCLK
    PA_11 --> SSEL (PGA_CS)
*/

///////////////
// Libraries //
///////////////
#include "mbed.h"
#include "BufferedSerial.h"  // solves issues of loosing data. alternative doing it yourself

///////////////
// #defines  //
///////////////

#define DEBUG_MOD1

/////////////
// Objects //
/////////////

// uart
BufferedSerial pc(USBTX, USBRX);
BufferedSerial xbee(D1, D0);

// SPI with PGA112
SPI spi(PB_5, PB_4, PB_3); // mosi, miso, sclk , SSEL

DigitalOut PGA_CS(PA_11); // chip select manual

///////////////
// variables //
///////////////

uint8_t in_byte=0;

///////////////
// Functions //
///////////////

////////////////////////
//  Main Code Setup : //
////////////////////////
int main()
{
    pc.baud(57600);
    xbee.baud(57600);
#ifdef DEBUG_MOD1
    pc.printf("MIC Test\r\n");
#endif

// Initialize PGA112
    // Disable PGA112
    PGA_CS=1;
    wait(0.1); // module startup
    // Init SPI format
    spi.format(16,0);
    spi.frequency(8000000);

    // Enable PGA112
    PGA_CS=0;
    // write Register
    spi.write(0x0000);
    // Disable PGA112
    PGA_CS=1;




    ///////////////////////
    //  Main Code Loop : //
    ///////////////////////
    while(1) {
        if (pc.readable()) {
            in_byte=pc.getc();
#ifdef DEBUG_MOD1
            pc.putc(in_byte);
#endif
            uint8_t writeMSB = 0x2A;
            uint8_t writeLSB = in_byte;
            //uint16_t writeU16 = ((writeMSB<<8) | (writeLSB&0x00FF));
            uint16_t writeU16 = ((writeMSB<<8) | (writeLSB));
            PGA_CS=0;
            // write Register
            spi.write(writeU16);
            // Disable PGA112
            PGA_CS=1;

        }// end serial
        
        if (xbee.readable()) {
            in_byte=xbee.getc();
#ifdef DEBUG_MOD1
            xbee.putc(in_byte);
#endif
            uint8_t writeMSB = 0x2A;
            uint8_t writeLSB = in_byte;
            //uint16_t writeU16 = ((writeMSB<<8) | (writeLSB&0x00FF));
            uint16_t writeU16 = ((writeMSB<<8) | (writeLSB));
            PGA_CS=0;
            // write Register
            spi.write(writeU16);
            // Disable PGA112
            PGA_CS=1;

        }// end serial

//    // Enable PGA112
//    PGA_CS=0;
//    // write Register
//    spi.write(0x2A00);
//    // Disable PGA112
//    PGA_CS=1;
//
//    // delay
//    wait(1.0);
//
//    // Enable PGA112
//    PGA_CS=0;
//    // write Register
//    spi.write(0x2A30);
//    // Disable PGA112
//    PGA_CS=1;
//
//    // delay
//    wait(1.0);

    }// end main loop
}// end main

///////////////
// Functions //
///////////////
